/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.application.SimulatorPlugin;
import de.renew.net.Net;
import de.renew.net.NetNotFoundException;
import de.renew.net.loading.NetLoader;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowNetSystem;

public class DefaultCompiledNetLoader
implements NetLoader {
    private ShadowNetLoader netLoader;

    public DefaultCompiledNetLoader(ShadowNetLoader shadowNetLoader) {
        if (shadowNetLoader == null) {
            throw new NullPointerException("Missing ShadowNetLoader.");
        }
        this.netLoader = shadowNetLoader;
    }

    @Override
    public Net loadNet(String string) throws NetNotFoundException {
        try {
            Net net;
            ShadowNetSystem shadowNetSystem = this.netLoader.loadShadowNetSystem(string);
            ShadowLookup shadowLookup = SimulatorPlugin.getCurrent().insertNets(shadowNetSystem);
            if (shadowLookup != null && (net = shadowLookup.getNet(string)) != null) {
                return net;
            }
        }
        catch (NetNotFoundException netNotFoundException) {
            throw netNotFoundException;
        }
        catch (Exception exception) {
            throw new NetNotFoundException(string, exception);
        }
        throw new NetNotFoundException(string);
    }
}

