/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.shadow.ShadowLookupExtension;
import de.renew.shadow.ShadowLookupExtensionFactory;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class ShadowLookup {
    private Hashtable<String, Net> netMap = new Hashtable();
    private HashSet<String> namesOfNewlyCompiledNets = new HashSet();
    private Hashtable<ShadowPlace, Place> placeMap = new Hashtable();
    private Hashtable<ShadowTransition, Transition> transitionMap = new Hashtable();
    private Hashtable<String, ShadowLookupExtension> extensions = new Hashtable();

    public void setNet(String string, Net net) {
        this.netMap.put(string, net);
    }

    public Net getNet(String string) {
        return this.netMap.get(string);
    }

    public Enumeration<String> allNetNames() {
        return this.netMap.keys();
    }

    public Iterator<String> allNewlyCompiledNetNames() {
        return this.namesOfNewlyCompiledNets.iterator();
    }

    public void set(ShadowPlace shadowPlace, Place place) {
        this.placeMap.put(shadowPlace, place);
        this.namesOfNewlyCompiledNets.add(shadowPlace.getNet().getName());
    }

    public Place get(ShadowPlace shadowPlace) {
        return this.placeMap.get(shadowPlace);
    }

    public Enumeration<ShadowPlace> allPlaces() {
        return this.placeMap.keys();
    }

    public void set(ShadowTransition shadowTransition, Transition transition) {
        this.transitionMap.put(shadowTransition, transition);
        this.namesOfNewlyCompiledNets.add(shadowTransition.getNet().getName());
    }

    public Transition get(ShadowTransition shadowTransition) {
        return this.transitionMap.get(shadowTransition);
    }

    public Enumeration<ShadowTransition> allTransitions() {
        return this.transitionMap.keys();
    }

    public synchronized ShadowLookupExtension getShadowLookupExtension(ShadowLookupExtensionFactory shadowLookupExtensionFactory) {
        ShadowLookupExtension shadowLookupExtension = this.extensions.get(shadowLookupExtensionFactory.getCategory());
        if (shadowLookupExtension == null) {
            shadowLookupExtension = shadowLookupExtensionFactory.createExtension();
            this.extensions.put(shadowLookupExtensionFactory.getCategory(), shadowLookupExtension);
        }
        return shadowLookupExtension;
    }

    public void makeNetsKnown() {
        for (Net net : this.netMap.values()) {
            net.makeKnown();
        }
    }

    public boolean containsNewlyCompiledNets() {
        return !this.namesOfNewlyCompiledNets.isEmpty();
    }
}

