/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.Net;
import de.renew.net.NetNotFoundException;
import de.renew.net.loading.NetLoader;
import de.renew.shadow.ShadowCompiler;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowPreprocessor;
import de.renew.shadow.SyntaxException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ShadowNetSystem
implements Serializable {
    public static Logger logger = Logger.getLogger(ShadowNetSystem.class);
    static final long serialVersionUID = 4619730346099695519L;
    private Set<ShadowNet> nets = new HashSet<ShadowNet>();
    private ShadowCompilerFactory defaultCompilerFactory = null;
    private transient Set<ShadowNet> compiledNets = new HashSet<ShadowNet>();
    private transient Set<ShadowNet> uncompiledNets = new HashSet<ShadowNet>();
    private transient ShadowNetLoader netLoader = null;

    public ShadowNetSystem(ShadowCompilerFactory shadowCompilerFactory) {
        this.setDefaultCompilerFactory(shadowCompilerFactory);
    }

    public ShadowNetSystem(ShadowCompilerFactory shadowCompilerFactory, ShadowNetLoader shadowNetLoader) {
        this(shadowCompilerFactory);
        this.setNetLoader(shadowNetLoader);
    }

    public void setDefaultCompilerFactory(ShadowCompilerFactory shadowCompilerFactory) {
        this.defaultCompilerFactory = shadowCompilerFactory;
        this.uncompiledNets.addAll(this.compiledNets);
        this.compiledNets.clear();
    }

    public ShadowCompilerFactory getDefaultCompilerFactory() {
        return this.defaultCompilerFactory;
    }

    public void setNetLoader(ShadowNetLoader shadowNetLoader) {
        this.netLoader = shadowNetLoader;
    }

    public ShadowNetLoader getNetLoader() {
        return this.netLoader;
    }

    protected void add(ShadowNet shadowNet) {
        this.nets.add(shadowNet);
        if (!this.compiledNets.contains(shadowNet)) {
            this.uncompiledNets.add(shadowNet);
        }
    }

    protected void remove(ShadowNet shadowNet) {
        this.nets.remove(shadowNet);
        this.compiledNets.remove(shadowNet);
        this.uncompiledNets.remove(shadowNet);
    }

    public void markAsCompiled(ShadowNet shadowNet) {
        if (this.nets.contains(shadowNet)) {
            this.compiledNets.add(shadowNet);
            this.uncompiledNets.remove(shadowNet);
        }
    }

    public Set<ShadowNet> elements() {
        return Collections.unmodifiableSet(this.nets);
    }

    private Set<ShadowNet> uncompiledElements() {
        return new HashSet<ShadowNet>(this.uncompiledNets);
    }

    private boolean hasUncompiledElements() {
        return !this.uncompiledNets.isEmpty();
    }

    public synchronized ShadowLookup compile() throws SyntaxException {
        logger.debug((Object)(String.valueOf(this) + " is compiled with default compiler factory " + String.valueOf(this.defaultCompilerFactory)));
        ShadowLookup shadowLookup = this.compile(new ShadowLookup(), true);
        return shadowLookup;
    }

    public synchronized ShadowLookup compileMore() throws SyntaxException {
        ShadowLookup shadowLookup = new ShadowLookup();
        Iterator<Net> iterator = Net.allKnownNets();
        while (iterator.hasNext()) {
            Net net = iterator.next();
            shadowLookup.setNet(net.getName(), net);
        }
        return this.compile(shadowLookup, false);
    }

    private ShadowLookup compile(ShadowLookup shadowLookup, boolean bl) throws SyntaxException {
        this.createNets(shadowLookup);
        this.preprocessNets(shadowLookup, bl);
        boolean bl2 = bl;
        while (this.hasUncompiledElements()) {
            for (ShadowNet shadowNet : this.uncompiledElements()) {
                ShadowCompiler shadowCompiler = shadowNet.createInititalizedShadowNetCompiler(shadowLookup);
                ShadowPreprocessor[] shadowPreprocessorArray = shadowCompiler.getRequiredPreprocessors();
                if (shadowPreprocessorArray != null && shadowPreprocessorArray.length > 0 && !bl2) {
                    throw new SyntaxException("Net " + shadowNet.getName() + " was dynamically loaded and requires a preprocessing phase. that is not supported", new String[0]);
                }
                logger.debug((Object)("compiling " + shadowNet.getName() + " using " + String.valueOf(shadowCompiler)));
                shadowCompiler.compile(shadowNet);
                this.markAsCompiled(shadowNet);
            }
            bl2 = false;
        }
        return shadowLookup;
    }

    private void createNets(ShadowLookup shadowLookup) throws SyntaxException {
        for (ShadowNet shadowNet : this.uncompiledElements()) {
            String string = shadowNet.getName();
            if (Net.isKnownNet(string) || shadowLookup.getNet(string) != null) {
                throw new SyntaxException("Detected two nets with the same name: " + shadowNet.getName() + ".");
            }
            Net net = shadowNet.createInititalizedShadowNetCompiler(shadowLookup).createNet(shadowNet.getName());
            shadowLookup.setNet(shadowNet.getName(), net);
        }
    }

    private void preprocessNets(ShadowLookup shadowLookup, boolean bl) throws SyntaxException {
        HashSet<ShadowPreprocessor> hashSet = new HashSet<ShadowPreprocessor>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (ShadowNet object2 : this.uncompiledElements()) {
            ShadowCompiler shadowCompiler = object2.createInititalizedShadowNetCompiler(shadowLookup);
            ShadowPreprocessor[] shadowPreprocessorArray = shadowCompiler.getRequiredPreprocessors();
            if (shadowPreprocessorArray == null || shadowPreprocessorArray.length <= 0) continue;
            hashSet.addAll(Arrays.asList(shadowPreprocessorArray));
            hashSet2.add(object2.getName());
        }
        if (hashSet.isEmpty()) {
            return;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer();
            if (hashSet2.size() == 1) {
                stringBuffer.append("The dynamically loaded net ");
                stringBuffer.append((String)hashSet2.iterator().next());
                stringBuffer.append(" requires");
            } else {
                stringBuffer.append("Some dynamically loaded nets (");
                Iterator iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(" require");
            }
            stringBuffer.append(" a preprocessing phase. This is not allowed.");
            throw new SyntaxException(stringBuffer.toString(), new String[0]);
        }
        for (ShadowPreprocessor shadowPreprocessor : hashSet) {
            shadowPreprocessor.setShadowLookup(shadowLookup);
            shadowPreprocessor.preprocess(this);
        }
    }

    private Net appendNet(ShadowLookup shadowLookup, String string) throws NetNotFoundException {
        if (this.getNetLoader() != null) {
            Net net;
            ShadowNet shadowNet = this.getNetLoader().loadShadowNet(string, this);
            if (!shadowNet.getName().equals(string)) {
                throw new NetNotFoundException(string + " (ShadowNetLoader provided " + shadowNet.getName() + " instead)");
            }
            try {
                net = shadowNet.createInititalizedShadowNetCompiler(shadowLookup).createNet(shadowNet.getName());
            }
            catch (SyntaxException syntaxException) {
                throw new NetNotFoundException(syntaxException);
            }
            shadowLookup.setNet(shadowNet.getName(), net);
            return net;
        }
        throw new NetNotFoundException(string);
    }

    LoopbackNetLoader createNetLoader(ShadowLookup shadowLookup) {
        return new LoopbackNetLoader(shadowLookup);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.uncompiledNets = new HashSet<ShadowNet>(this.nets);
        this.compiledNets = new HashSet<ShadowNet>();
    }

    private class LoopbackNetLoader
    implements NetLoader {
        private ShadowLookup lookup;

        LoopbackNetLoader(ShadowLookup shadowLookup) {
            this.lookup = shadowLookup;
        }

        @Override
        public Net loadNet(String string) throws NetNotFoundException {
            return ShadowNetSystem.this.appendNet(this.lookup, string);
        }
    }
}

