/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.BacklinkSet;
import de.renew.unify.IdentityWrapper;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.RecorderChecker;
import de.renew.unify.Referable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.StateRecorder;
import de.renew.unify.StateRestorer;
import de.renew.unify.Unifiable;
import de.renew.unify.Unknown;
import java.util.Set;

public final class Calculator
implements Unifiable,
Referable,
Referer {
    private BacklinkSet backlinkSet;
    private final Reference reference;
    private final RecorderChecker recorderChecker;
    private final Class<?> type;

    Calculator(Class<?> clazz, Object object, StateRecorder stateRecorder) {
        this.recorderChecker = new RecorderChecker(stateRecorder);
        this.reference = new Reference(object, this, stateRecorder);
        this.type = clazz;
        if (!this.isComplete()) {
            this.backlinkSet = new BacklinkSet();
        }
    }

    @Override
    public boolean isComplete() {
        return this.reference.complete;
    }

    @Override
    public boolean isBound() {
        return false;
    }

    public Class<?> getType() {
        return this.type;
    }

    private void checkBacklinkSet() {
        if (this.backlinkSet == null) {
            if (this.isComplete()) {
                throw new RuntimeException("A complete tuple received a backlink. Strange");
            }
            throw new RuntimeException("An incomplete tuple lacks a backlink set. Strange");
        }
    }

    @Override
    public void addBacklink(Reference reference, StateRecorder stateRecorder) {
        this.recorderChecker.checkRecorder(stateRecorder);
        this.checkBacklinkSet();
        this.backlinkSet.addBacklink(reference, stateRecorder);
    }

    @Override
    public void possiblyCompleted(Set<Notifiable> set, StateRecorder stateRecorder) throws Impossible {
        if (this.isComplete()) {
            this.checkBacklinkSet();
            this.backlinkSet.updateBacklinked(this, this, set, stateRecorder);
            final BacklinkSet backlinkSet = this.backlinkSet;
            if (stateRecorder != null) {
                stateRecorder.record(new StateRestorer(){

                    @Override
                    public void restore() {
                        Calculator.this.backlinkSet = backlinkSet;
                    }
                });
            }
            this.backlinkSet = null;
        }
    }

    @Override
    public void occursCheck(Unknown unknown, Set<IdentityWrapper> set) throws Impossible {
        if (this.reference.complete) {
            return;
        }
        IdentityWrapper identityWrapper = new IdentityWrapper(this);
        if (set.contains(identityWrapper)) {
            return;
        }
        set.add(identityWrapper);
        this.reference.occursCheck(unknown, set);
    }

    public boolean equals(Object object) {
        throw new RuntimeException("Somebody compared a calculator.");
    }

    public int hashCode() {
        throw new RuntimeException("Somebody took the hash code of a calculator.");
    }

    public String toString() {
        return "<pending: " + String.valueOf(this.getType()) + ">";
    }
}

