/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.io.ImportHolder;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.navigator.AutosaveController;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorExtender;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.OpenNavigatorCommand;
import de.renew.navigator.gui.NavigatorGuiProxy;
import de.renew.navigator.io.FileFilterBuilderImpl;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.plugin.PluginManager;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.annotations.Provides;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.di.DIPlugin;
import java.awt.Toolkit;
import javax.swing.JMenuItem;
import javax.swing.JTree;

public final class NavigatorPlugin
extends DIPlugin
implements NavigatorExtender {
    private final MenuManager menuManager;
    private JMenuItem openNavigatorItem;
    private static final String OPEN_NAVIGATOR_COMMAND_MENU_ID = "de.renew.navigator.show";
    private final NavigatorFileTree model = new NavigatorFileTree();
    private final AutosaveController autosave;
    private final FilesystemController filesystem;
    private final NavigatorGui gui;

    @Inject
    public NavigatorPlugin(MenuManager menuManager, ImportHolder importHolder, IOHelper iOHelper) {
        this.menuManager = menuManager;
        this.initMenu();
        FileFilterBuilderImpl fileFilterBuilderImpl = new FileFilterBuilderImpl(iOHelper, importHolder);
        this.autosave = new AutosaveController(this);
        this.filesystem = new FilesystemController(this, fileFilterBuilderImpl);
        this.gui = new NavigatorGuiProxy(this.filesystem, this);
    }

    @Override
    @Provides
    public NavigatorFileTree getModel() {
        return this.model;
    }

    @Provides
    public NavigatorGui getGui() {
        return this.gui;
    }

    public void init() {
        PluginManager pluginManager = PluginManager.getInstance();
        if (pluginManager != null) {
            pluginManager.addCLCommand("navigator", (CLCommand)new OpenNavigatorCommand(this));
        }
        this.initControllers();
    }

    private void initMenu() {
        this.openNavigatorItem = new CommandMenuItem((Command)new OpenNavigatorCommand(this), 78, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.openNavigatorItem.putClientProperty("ch.ifa.draw.menu.id", OPEN_NAVIGATOR_COMMAND_MENU_ID);
        this.menuManager.registerMenu("File", this.openNavigatorItem, 2, 0);
    }

    public boolean cleanup() {
        PluginManager pluginManager;
        this.gui.closeWindow();
        if (this.openNavigatorItem != null) {
            this.menuManager.unregisterMenu(this.openNavigatorItem);
            this.openNavigatorItem = null;
        }
        if ((pluginManager = PluginManager.getInstance()) != null) {
            pluginManager.removeCLCommand("navigator");
        }
        return true;
    }

    @Override
    public void registerExtension(NavigatorExtension navigatorExtension) {
        this.gui.addExtension(navigatorExtension);
    }

    @Override
    public boolean deregisterExtension(NavigatorExtension navigatorExtension) {
        return this.gui.removeExtension(navigatorExtension);
    }

    @Override
    public JTree getTree() {
        return this.gui.getTree();
    }

    public void openNavigator() {
        if (this.autosave.isAutosaveFileExisting()) {
            this.autosave.loadModel();
        }
        this.gui.openWindow();
    }

    protected void initControllers() {
        this.model.addObserver(this.autosave);
        this.model.addObserver(this.filesystem);
    }

    @Deprecated
    public void openInNavigator() {
        this.openNavigator();
    }

    @Deprecated
    public static NavigatorPlugin getCurrent() {
        return (NavigatorPlugin)PluginManager.getInstance().getPluginByName("Navigator");
    }
}

