/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui.filters;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.SearchFilter;
import java.awt.event.ActionEvent;

public abstract class AbstractFilterAction
extends NavigatorAction {
    private final SearchFilter searchFilter;
    private final NavigatorFileTree fileTree;

    public AbstractFilterAction(SearchFilter searchFilter, String string, NavigatorFileTree navigatorFileTree) {
        super(AbstractFilterAction.nameByFilter(searchFilter), string, null);
        this.searchFilter = searchFilter;
        this.fileTree = navigatorFileTree;
    }

    private static String nameByFilter(SearchFilter searchFilter) {
        return searchFilter.getName();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = AbstractFilterAction.nameByFilter(this.searchFilter);
        boolean bl = this.fileTree.getFileFilterByName(string) == null;
        this.putValue("active", bl);
        if (bl) {
            this.fileTree.activateFileFilter(this.searchFilter);
            this.fileTree.notifyObservers();
            return;
        }
        this.fileTree.deactivateFileFilter(string);
        this.fileTree.notifyObservers();
    }
}

