/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.CompressableOutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class BitOutputStream
extends CompressableOutputStream
implements FinishableOutputStream {
    private int bits = 0;
    private int bitPos = 0;

    public BitOutputStream(OutputStream out) {
        super(out);
    }

    public void finish() throws IOException {
        this.flushByte();
        if (this.out instanceof FinishableOutputStream) {
            ((FinishableOutputStream)((Object)this.out)).finish();
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    protected void flushByte() throws IOException {
        if (this.bitPos == 0) {
            return;
        }
        this.write(this.bits);
        this.bits = 0;
        this.bitPos = 0;
    }

    public void byteAlign() throws IOException {
        this.flushByte();
    }

    public void writeBitFlag(boolean bit) throws IOException {
        this.writeUBits(bit ? 1L : 0L, 1);
    }

    public void writeSBits(long value, int n) throws IOException {
        long tmp = value & Integer.MAX_VALUE;
        if (value < 0L) {
            tmp |= 1L << n - 1;
        }
        this.writeUBits(tmp, n);
    }

    public void writeFBits(float value, int n) throws IOException {
        if (n == 0) {
            return;
        }
        long tmp = (long)(value * 65536.0f);
        this.writeSBits(tmp, n);
    }

    public void writeUBits(long value, int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.bitPos == 0) {
            this.bitPos = 8;
        }
        int bitNum = n;
        while (bitNum > 0) {
            while (this.bitPos > 0 && bitNum > 0) {
                long or = value & 1L << bitNum - 1;
                int shift = this.bitPos - bitNum;
                or = shift < 0 ? (or >>= -shift) : (or <<= shift);
                this.bits = (int)((long)this.bits | or);
                --bitNum;
                --this.bitPos;
            }
            if (this.bitPos != 0) continue;
            this.write(this.bits);
            this.bits = 0;
            if (bitNum <= 0) continue;
            this.bitPos = 8;
        }
    }

    public static int minBits(float number) {
        return BitOutputStream.minBits((int)number, true) + 16;
    }

    public static int minBits(long number) {
        return BitOutputStream.minBits(number, number < 0L);
    }

    public static int minBits(long number, boolean signed) {
        int i;
        number = Math.abs(number);
        long x = 1L;
        for (i = 1; i <= 64 && (x <<= 1) <= number; ++i) {
        }
        return i + (signed ? 1 : 0);
    }
}

