/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.Palette;
import de.renew.application.SimulatorPlugin;
import de.renew.gui.FormalismGuiCreator;
import de.renew.gui.GuiPlugin;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.PaletteHolder;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PropertyHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class JavaGuiCreator
implements FormalismGuiCreator {
    public static Logger logger = Logger.getLogger(JavaGuiCreator.class);
    private boolean toolsVisible = false;
    private Palette sequentialTools = null;
    private JCheckBoxMenuItem sequentialItem;

    @Override
    public JMenuItem createMenu() {
        int n = PropertyHelper.getIntProperty((Properties)this.getSimulatorPlugin().getProperties(), (String)"de.renew.simulatorMode", (int)1);
        boolean bl = n == -1;
        this.sequentialItem = new JCheckBoxMenuItem("Show sequential-only arcs", bl);
        this.sequentialItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaGuiCreator.this.sequentialChanged();
            }
        });
        this.sequentialChanged();
        return this.sequentialItem;
    }

    @Override
    public Palette createPalette() {
        return null;
    }

    @Override
    public void formalismActivated() {
    }

    @Override
    public void formalismDeactivated() {
        this.hideSequentialPalette();
    }

    private void sequentialChanged() {
        boolean bl = this.sequentialItem.isSelected();
        if (bl) {
            this.createSequentialPalette();
        } else {
            this.hideSequentialPalette();
        }
    }

    private void hideSequentialPalette() {
        if (this.sequentialTools != null && this.toolsVisible) {
            GuiPlugin guiPlugin = GuiPlugin.getCurrent();
            guiPlugin.getPaletteHolder().removePalette(this.sequentialTools);
            this.toolsVisible = false;
        }
    }

    private void createSequentialPalette() {
        DrawingEditor drawingEditor;
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        PaletteHolder paletteHolder = guiPlugin.getPaletteHolder();
        if (this.sequentialTools == null) {
            drawingEditor = guiPlugin.getDrawingEditor();
            ConnectionTool connectionTool = new ConnectionTool(drawingEditor, (ConnectionFigure)InhibitorConnection.InhibitorArc);
            this.sequentialTools = new Palette("net elements for sequential mode");
            ToolButton toolButton = paletteHolder.createToolButton("/de/renew/gui/images/INHIB", "InhibitorArc Tool", (Tool)connectionTool);
            this.sequentialTools.add(toolButton);
            connectionTool = new ConnectionTool(drawingEditor, (ConnectionFigure)HollowDoubleArcConnection.HollowArc);
            toolButton = paletteHolder.createToolButton("/de/renew/gui/images/DHARC", "ClearArc Tool", (Tool)connectionTool);
            this.sequentialTools.add(toolButton);
        }
        if (!this.toolsVisible) {
            drawingEditor = this.getSimulatorPlugin().getProperties();
            if (!drawingEditor.getProperty("de.renew.simulatorMode", "").trim().equals("-1")) {
                drawingEditor.setProperty("de.renew.simulatorMode", "-1");
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"For your convenience, the sequential simulation mode has been turned on, too.");
                    logger.info((Object)"In order to reset your simulation to concurrent simulation mode do: set de.renew.simulatorMode=1");
                    logger.info((Object)"or uncheck the propterty in the \"Configure Simulation\" dialog.");
                }
            }
            paletteHolder.addPalette(this.sequentialTools);
            this.toolsVisible = true;
        }
    }

    private SimulatorPlugin getSimulatorPlugin() {
        return (SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next();
    }

    public FormalismGuiCreator getSequentialJavaGuiCreator() {
        return new SequentialJavaGuiCreator();
    }

    private class SequentialJavaGuiCreator
    implements FormalismGuiCreator {
        private SequentialJavaGuiCreator() {
        }

        @Override
        public JMenuItem createMenu() {
            return null;
        }

        @Override
        public Palette createPalette() {
            return null;
        }

        @Override
        public void formalismActivated() {
            JavaGuiCreator.this.createSequentialPalette();
        }

        @Override
        public void formalismDeactivated() {
            JavaGuiCreator.this.hideSequentialPalette();
        }
    }
}

