/*
 * Decompiled with CFR 0.152.
 */
package de.renew.call;

import de.renew.call.ParseException;
import de.renew.call.StubParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;

public class StubCompiler {
    private static final String AUTO_COMMENT = "// This file was automatically generated. Do not modify.";
    private File _toDir;

    public StubCompiler() {
        this(null);
    }

    public StubCompiler(File file) {
        this._toDir = file;
    }

    public File compileStub(File file) throws ParseException, IOException {
        FileReader fileReader = null;
        fileReader = new FileReader(file);
        StubParser stubParser = new StubParser(fileReader);
        stubParser.StubFile();
        File file2 = this.getTarget(file, stubParser.getPackage());
        if (!this.canWrite(file2)) {
            throw new ParseException("not allowed to edit file");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        bufferedWriter.write("// This file was automatically generated. Do not modify.\n");
        bufferedWriter.write(stubParser.getOutput());
        ((Writer)bufferedWriter).close();
        return file2;
    }

    private boolean canWrite(File file) throws IOException {
        if (!file.isFile()) {
            return true;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        return string == null || string.startsWith(AUTO_COMMENT);
    }

    private File getTarget(File file, String string) throws IOException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._toDir == null) {
            object = file.getParent();
            if (object != null) {
                stringBuffer.append((String)object + File.separator);
            } else {
                stringBuffer.append("." + File.separator);
            }
        } else {
            stringBuffer.append(String.valueOf(this._toDir) + File.separator);
            object = new StringTokenizer(string, ".");
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringBuffer.append(((StringTokenizer)object).nextToken() + File.separator);
            }
        }
        object = file.getName();
        String string2 = ((String)object).substring(0, ((String)object).lastIndexOf(46)) + ".java";
        stringBuffer.append(string2);
        File file2 = new File(stringBuffer.toString());
        file2.getParentFile().mkdirs();
        if (!file2.createNewFile() && !file2.canWrite()) {
            throw new IOException("Could not specify target File of source file '" + String.valueOf(file) + "'.\nEstimated '" + String.valueOf(file2) + "' was errorneous.");
        }
        return file2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            StubCompiler.usage();
            System.exit(1);
        }
        File file = null;
        StubCompiler stubCompiler = new StubCompiler(file);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-d")) {
                if (!(file = new File(stringArray[++i])).isDirectory()) {
                    System.err.println("\n\nSpecified target directory '" + String.valueOf(file) + "' does not exist.\n\n");
                    System.exit(1);
                }
                stubCompiler = new StubCompiler(file);
                continue;
            }
            File file2 = new File(stringArray[i]);
            if (!file2.isFile()) {
                System.err.println("Source file '" + String.valueOf(file2) + "'could not be found.");
                System.exit(1);
            }
            if (!file2.canRead()) {
                System.err.println("Cannot read source file '" + String.valueOf(file2) + "'.Ignoring this argument.");
                continue;
            }
            try {
                File file3 = stubCompiler.compileStub(file2);
                System.err.println("Target file " + String.valueOf(file3) + " generated.");
                continue;
            }
            catch (ParseException parseException) {
                System.err.println("An error occurred during parsing the stub file.");
                System.err.println(parseException.getMessage());
                continue;
            }
            catch (IOException iOException) {
                System.err.println("An error occurred while reading source file or writing the target file:");
                System.err.println(iOException.getMessage());
            }
        }
    }

    private static void usage() {
        System.err.println("Renew Stub Compiler\n\nGenerates .java files from .stub files\nAll .stub files provided as arguments to this command are\ncompiled to .java files. These can be used to unify with \nsynchronous channels out of java-Code.\n\nUsage:\njava de.renew.call.StubCompiler {-d <todir>} {stub-files}...\n\n-d <todir>\n        Directory in which java Files are generated.\n        Like java files, they are created into their package path.\n        If not specified, files will be generated in the same path.\n        \n{stub-files}...\n        some .stub Files that shall be compiled.\n        Existing Files will be overwritten unless the \n        \" do not modify \" warning has been removed.\n\n");
    }
}

