/*
 * Decompiled with CFR 0.152.
 */
package de.renew.watch;

import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorExtensionAdapter;
import de.renew.application.SimulatorPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.watch.ChannelSupervisor;
import java.util.Collection;
import org.apache.log4j.Logger;

public class WatchPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(WatchPlugin.class);
    private SimulatorPlugin simPlugin;
    private WatchExtension watchExtension;

    public WatchPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public void init() {
        PluginManager pluginManager = PluginManager.getInstance();
        Collection collection = pluginManager.getPluginsProviding("de.renew.simulator");
        this.simPlugin = (SimulatorPlugin)collection.iterator().next();
        this.watchExtension = new WatchExtension();
        this.simPlugin.addExtension((SimulatorExtension)this.watchExtension);
    }

    public boolean cleanup() {
        if (this.simPlugin != null && this.watchExtension != null) {
            this.simPlugin.removeExtension((SimulatorExtension)this.watchExtension);
            this.simPlugin = null;
            this.watchExtension = null;
        }
        return true;
    }

    private class WatchExtension
    extends SimulatorExtensionAdapter {
        private WatchExtension() {
        }

        public void simulationSetup(SimulationEnvironment simulationEnvironment) {
            logger.debug((Object)"WatchPlugin: Resetting channel supervisor.");
            ChannelSupervisor.activate();
        }

        public void simulationTerminated() {
            logger.debug((Object)"WatchPlugin: Resetting channel supervisor.");
            ChannelSupervisor.reset();
        }
    }
}

