/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.PrimaryPart;
import de.renew.formalism.java.Suggestion;
import de.renew.formalism.java.TypedExpression;
import de.renew.unify.List;
import de.renew.unify.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

public class VariableSuggestion
extends Suggestion {
    private final Class<?> type;
    private final boolean importNeeded;
    private boolean editDesired = false;

    public static Collection<VariableSuggestion> suggest(PrimaryPart primaryPart, TypedExpression typedExpression, ParsedDeclarationNode parsedDeclarationNode) {
        String string = (String)primaryPart.obj;
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = VariableSuggestion.suggestByRightExpression(typedExpression);
        if (clazz != null) {
            arrayList.add(clazz);
        }
        arrayList.addAll(VariableSuggestion.suggestImported(string.charAt(0), parsedDeclarationNode.getWellKnownClasses()));
        arrayList.addAll(VariableSuggestion.suggestPrimitives(string.charAt(0)));
        arrayList.addAll(VariableSuggestion.suggestStatic());
        LinkedHashSet<VariableSuggestion> linkedHashSet = new LinkedHashSet<VariableSuggestion>();
        boolean bl = true;
        for (Class clazz2 : arrayList) {
            boolean bl2 = false;
            if (clazz2.getPackage() != null && parsedDeclarationNode.interpreteName(clazz2.getSimpleName()) == null) {
                bl2 = true;
            }
            VariableSuggestion variableSuggestion = new VariableSuggestion(string, clazz2, bl2);
            if (clazz2 == Object.class && bl) {
                variableSuggestion.editDesired = true;
                bl = false;
            }
            linkedHashSet.add(variableSuggestion);
        }
        return linkedHashSet;
    }

    private static Class<?> suggestByRightExpression(TypedExpression typedExpression) {
        if (typedExpression != null && typedExpression.getType() != null) {
            return typedExpression.getType();
        }
        return null;
    }

    private static Collection<Class<?>> suggestPrimitives(char c) {
        ArrayList arrayList = new ArrayList();
        char c2 = Character.toUpperCase(c);
        for (Class clazz : Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class)) {
            if (clazz.getSimpleName().charAt(0) != c2) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private static Collection<Class<?>> suggestImported(char c, Map<String, Class<?>> map) {
        ArrayList arrayList = new ArrayList();
        char c2 = Character.toUpperCase(c);
        for (String string : map.keySet()) {
            if (string.charAt(0) != c2) continue;
            arrayList.add(map.get(string));
        }
        return arrayList;
    }

    private static Collection<Class<?>> suggestStatic() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(List.class);
        arrayList.add(Tuple.class);
        arrayList.add(Object.class);
        arrayList.add(Object.class);
        return arrayList;
    }

    public VariableSuggestion(String string, Class<?> clazz, boolean bl) {
        super(string, VariableSuggestion.unboxPrimitive(clazz));
        this.type = clazz;
        this.importNeeded = bl;
    }

    public boolean isImportNeeded() {
        return this.importNeeded;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isEditDesired() {
        return this.editDesired;
    }

    @Override
    public String toString() {
        String string = this.type.getPackage() == null ? "" : this.type.getPackage().getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>Declare ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" as ");
        stringBuilder.append(this.getTypeName());
        if (this.editDesired) {
            stringBuilder.append(" and edit");
        }
        stringBuilder.append(" <font color=gray>- ");
        stringBuilder.append(string);
        stringBuilder.append("</font></html>");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        VariableSuggestion variableSuggestion = (VariableSuggestion)object;
        return this.type.equals(variableSuggestion.type) && this.editDesired == variableSuggestion.editDesired;
    }

    public int hashCode() {
        return this.type.hashCode() + (this.editDesired ? 0 : 1);
    }

    private static String unboxPrimitive(Class<?> clazz) {
        if (clazz == Byte.class) {
            return "byte";
        }
        if (clazz == Short.class) {
            return "short";
        }
        if (clazz == Integer.class) {
            return "int";
        }
        if (clazz == Long.class) {
            return "long";
        }
        if (clazz == Float.class) {
            return "float";
        }
        if (clazz == Double.class) {
            return "double";
        }
        if (clazz == Boolean.class) {
            return "boolean";
        }
        if (clazz == Character.class) {
            return "char";
        }
        return clazz.getSimpleName();
    }
}

