/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.SnapshotHistory;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UndoRedoManager {
    private static final int UNDOSTEPS = 20;
    private static final int ACCUMULATIONTIME = 800;
    private Hashtable<Drawing, SnapshotHistory> undoHistoryTable = new Hashtable();
    private Hashtable<Drawing, SnapshotHistory> redoHistoryTable = new Hashtable();
    private DrawingEditor editor;
    private Hashtable<Drawing, ScheduledFuture<?>> accumulationCommitFutures = new Hashtable();
    private ScheduledExecutorService scheduledThreadPool;
    private static Logger logger = Logger.getLogger(UndoRedoManager.class);

    public UndoRedoManager(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
        this.scheduledThreadPool = Executors.newScheduledThreadPool(0);
    }

    public void prepareUndoSnapshot(Drawing drawing) {
        this.commitPendingAccumulatedUndoSnapshot(drawing);
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        if (snapshotHistory != null) {
            snapshotHistory.prepareSnapshot();
        }
    }

    public void commitUndoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        SnapshotHistory snapshotHistory2 = this.getRedoHistory(drawing);
        if (snapshotHistory != null) {
            snapshotHistory.commitSnapshot();
            snapshotHistory2.clear();
            this.editor.menuStateChanged();
        }
    }

    public void restoreUndoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        SnapshotHistory snapshotHistory2 = this.getRedoHistory(drawing);
        this.commitPendingAccumulatedUndoSnapshot(drawing);
        if (snapshotHistory != null) {
            if (!snapshotHistory.isEmpty()) {
                snapshotHistory2.takeSnapshot();
                snapshotHistory.restoreSnapshot();
                this.editor.showStatus("Undone.");
            } else {
                this.editor.showStatus("Nothing to undo.");
            }
        }
    }

    public void restoreRedoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.getUndoHistory(drawing);
        SnapshotHistory snapshotHistory2 = this.getRedoHistory(drawing);
        this.commitPendingAccumulatedUndoSnapshot(drawing);
        if (snapshotHistory2 != null) {
            if (!snapshotHistory2.isEmpty()) {
                snapshotHistory.takeSnapshot();
                snapshotHistory2.restoreSnapshot();
                this.editor.showStatus("Redone.");
            } else {
                this.editor.showStatus("Nothing to redo.");
            }
        }
    }

    public SnapshotHistory getUndoHistory(Drawing drawing) {
        return this.undoHistoryTable.get(drawing);
    }

    public SnapshotHistory getRedoHistory(Drawing drawing) {
        return this.redoHistoryTable.get(drawing);
    }

    public void clearUndoHistory(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.undoHistoryTable.get(drawing);
        SnapshotHistory snapshotHistory2 = this.redoHistoryTable.get(drawing);
        if (snapshotHistory != null) {
            snapshotHistory.clear();
            snapshotHistory2.clear();
            this.editor.menuStateChanged();
        }
        this.cancelPendingAccumulatedUndoSnapshot(drawing);
    }

    public void newUndoHistory(Drawing drawing) {
        SnapshotHistory snapshotHistory = this.undoHistoryTable.get(drawing);
        if (snapshotHistory == null) {
            this.undoHistoryTable.put(drawing, new SnapshotHistory(drawing, 20));
            this.redoHistoryTable.put(drawing, new SnapshotHistory(drawing, 20));
        }
    }

    public void removeUndoHistory(Drawing drawing) {
        this.undoHistoryTable.remove(drawing);
        this.redoHistoryTable.remove(drawing);
        this.cancelPendingAccumulatedUndoSnapshot(drawing);
        this.editor.menuStateChanged();
    }

    private void cancelPendingAccumulatedUndoSnapshot(Drawing drawing) {
        if (this.accumulationCommitFutures.containsKey(drawing)) {
            ScheduledFuture<?> scheduledFuture = this.accumulationCommitFutures.remove(drawing);
            scheduledFuture.cancel(true);
        }
    }

    private boolean isAccumulatedUndoSnapshotPending(Drawing drawing) {
        ScheduledFuture<?> scheduledFuture;
        boolean bl = false;
        if (this.accumulationCommitFutures.containsKey(drawing) && !(scheduledFuture = this.accumulationCommitFutures.get(drawing)).isCancelled() && !scheduledFuture.isDone()) {
            bl = true;
        }
        return bl;
    }

    private void commitPendingAccumulatedUndoSnapshot(Drawing drawing) {
        if (this.isAccumulatedUndoSnapshotPending(drawing)) {
            this.cancelPendingAccumulatedUndoSnapshot(drawing);
            this.commitUndoSnapshot(drawing);
        }
    }

    public void prepareAccumulatedUndoSnapshot(Drawing drawing) {
        SnapshotHistory snapshotHistory;
        if (!this.isAccumulatedUndoSnapshotPending(drawing) && (snapshotHistory = this.getUndoHistory(drawing)) != null) {
            snapshotHistory.prepareSnapshot();
        }
    }

    public void triggerAccumulatedUndoSnapshot(final Drawing drawing) {
        this.cancelPendingAccumulatedUndoSnapshot(drawing);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UndoRedoManager.this.commitUndoSnapshot(drawing);
                logger.debug((Object)"Commiting accumulated snapshot.");
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.debug((Object)"Scheduled accumulated snapshot task was canceled.");
                }
            }
        };
        ScheduledFuture<?> scheduledFuture = this.scheduledThreadPool.schedule(runnable2, 800L, TimeUnit.MILLISECONDS);
        this.accumulationCommitFutures.put(drawing, scheduledFuture);
    }
}

