/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.ArcOccurrence;
import java.util.Collection;
import java.util.Vector;

public class Arc
implements TransitionInscription {
    public static final int in = -1;
    public static final int test = 0;
    public static final int out = 1;
    public static final int both = 2;
    public static final int fastBoth = 3;
    public static final int fastTest = 4;
    public static final int inhibitor = 5;
    public static final int bothOT = 6;
    Place place;
    Transition transition;
    int arcType;
    Expression tokenExpr;
    Expression timeExpr;
    boolean trace;

    public Arc(Place place, Transition transition, int n, Expression expression, Expression expression2) {
        if (n < -1 || n > 6) {
            throw new RuntimeException("Bad arc type: " + n + ".");
        }
        this.place = place;
        this.transition = transition;
        this.arcType = n;
        this.tokenExpr = expression;
        this.timeExpr = expression2;
        this.trace = true;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public boolean isTestArc() {
        return this.arcType == 0 || this.arcType == 4;
    }

    public boolean isUntimedArc() {
        return this.isTestArc() || this.arcType == 5;
    }

    @Override
    public Collection<Occurrence> makeOccurrences(VariableMapper variableMapper, NetInstance netInstance, Searcher searcher) {
        Vector<Occurrence> vector = new Vector<Occurrence>();
        vector.add(new ArcOccurrence(this, variableMapper, netInstance));
        return vector;
    }
}

