/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.arc.FlexibleArc;
import de.renew.net.arc.FlexibleArcBinder;
import de.renew.net.arc.FlexibleInArcExecutable;
import de.renew.net.arc.FlexibleOutArcExecutable;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

class FlexibleArcOccurrence
extends AbstractOccurrence {
    SimulatablePlaceInstance placeInstance;
    VariableMapper mapper;
    Variable tokenVar;
    FlexibleArc arc;
    Vector<Object> inTokens;

    public FlexibleArcOccurrence(FlexibleArc flexibleArc, VariableMapper variableMapper, NetInstance netInstance) {
        super(netInstance.getInstance(flexibleArc.transition));
        this.arc = flexibleArc;
        this.mapper = variableMapper;
        this.placeInstance = (SimulatablePlaceInstance)netInstance.getInstance(flexibleArc.place);
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        this.tokenVar = new Variable(this.arc.expression.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker), searcher.recorder);
        if (this.arc.arcType == 1) {
            searcher.calcChecker.addLateVariable(this.tokenVar, searcher.recorder);
            return Collections.emptySet();
        }
        Vector<Binder> vector = new Vector<Binder>();
        vector.add(new FlexibleArcBinder(this));
        return vector;
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        Vector<Executable> vector = new Vector<Executable>();
        switch (this.arc.arcType) {
            case 1: {
                Variable variable = (Variable)variableMapperCopier.getCopier().copy(this.tokenVar);
                vector.add(new FlexibleOutArcExecutable(this.placeInstance, this.getTransition(), variable, this.arc));
                return vector;
            }
            case -1: 
            case 3: {
                vector.add(new FlexibleInArcExecutable(this.placeInstance, this.getTransition(), this.inTokens, this.arc));
                return vector;
            }
        }
        throw new RuntimeException("Bad arc type.");
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        return null;
    }
}

