/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ant;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.tools.ant.Task;

public class AntTaskLogAppender
extends AppenderSkeleton {
    private static AntTaskLogAppender instance = null;
    private Task logTask;

    private AntTaskLogAppender() {
    }

    private void setLogTask(Task task) {
        this.logTask = task;
    }

    public static synchronized AntTaskLogAppender getInstance(Task task) {
        if (instance == null) {
            instance = new AntTaskLogAppender();
        }
        instance.setLogTask(task);
        if (task != null) {
            task.log("Attaching Renew->Ant log forwarder to task: " + String.valueOf(task), 3);
        }
        return instance;
    }

    public void close() {
    }

    public void append(LoggingEvent loggingEvent) {
        this.doAppend(loggingEvent);
    }

    public boolean requiresLayout() {
        return false;
    }

    public synchronized void doAppend(LoggingEvent loggingEvent) {
        int n = 3;
        if (loggingEvent.getLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
            n = 0;
        } else if (loggingEvent.getLevel().isGreaterOrEqual((Priority)Level.WARN)) {
            n = 1;
        } else if (loggingEvent.getLevel().isGreaterOrEqual((Priority)Level.INFO)) {
            n = 2;
        }
        if (this.logTask != null) {
            this.logTask.log(loggingEvent.getMessage().toString(), n);
        }
    }
}

