/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.UndoableTool;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PolygonTool
extends UndoableTool {
    private PolygonFigure fPolygon;
    private int fLastX;
    private int fLastY;

    public PolygonTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    @Override
    public void activate() {
        super.activate();
        this.fPolygon = null;
    }

    @Override
    public void deactivate() {
        if (this.fPolygon != null) {
            this.fPolygon.smoothPoints();
            if (this.fPolygon.pointCount() < 3 || this.fPolygon.size().width < 4 || this.fPolygon.size().height < 4) {
                this.drawing().remove(this.fPolygon);
                this.noChangesMade();
            }
        }
        this.fPolygon = null;
        super.deactivate();
    }

    private void addPoint(int n, int n2) {
        if (this.fPolygon == null) {
            this.fPolygon = new PolygonFigure(n, n2);
            this.view().add(this.fPolygon);
            this.fPolygon.addPoint(n, n2);
            this.changesMade();
        } else if (this.fLastX != n || this.fLastY != n2) {
            this.fPolygon.addPoint(n, n2);
        }
        this.fLastX = n;
        this.fLastY = n2;
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getClickCount() >= 2) {
            if (this.fPolygon != null) {
                this.fPolygon.smoothPoints();
                this.editor().toolDone();
            }
            this.fPolygon = null;
        } else {
            this.addPoint(n, n2);
        }
    }

    @Override
    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        if (this.fPolygon != null && this.fPolygon.pointCount() > 1) {
            this.fPolygon.setPointAt(new Point(n, n2), this.fPolygon.pointCount() - 1);
            this.view().checkDamage();
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        this.addPoint(n, n2);
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
    }
}

