/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.DecoratorFigure;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class BorderDecorator
extends DecoratorFigure {
    private static final long serialVersionUID = 1205601808259084917L;
    private int borderDecoratorSerializedDataVersion = 1;

    public BorderDecorator() {
    }

    public BorderDecorator(Figure figure) {
        super(figure);
    }

    private Point border() {
        return new Point(3, 3);
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        super.draw(graphics);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.setColor(Color.gray);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    @Override
    public Rectangle displayBox() {
        Rectangle rectangle = this.fComponent.displayBox();
        rectangle.grow(this.border().x, this.border().y);
        return rectangle;
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        Rectangle rectangle = figureChangeEvent.getInvalidatedRectangle();
        rectangle.grow(this.border().x, this.border().y);
        super.figureInvalidated(new FigureChangeEvent(figureChangeEvent.getFigure(), rectangle));
    }

    @Override
    public Insets connectionInsets() {
        Insets insets = super.connectionInsets();
        insets.top -= 3;
        insets.bottom -= 3;
        insets.left -= 3;
        insets.right -= 3;
        return insets;
    }
}

