/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;
import java.awt.Color;

public class ChangeAttributeCommand
extends UndoableCommand {
    private String fAttribute;
    private Object fValue;

    public ChangeAttributeCommand(String string, String string2, Object object) {
        super(string);
        this.fAttribute = string2;
        this.fValue = object;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView drawingView = this.getEditor().view();
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Object object = figure.getAttribute(this.fAttribute);
            if (object instanceof Color && this.fValue instanceof Color) {
                Color color = (Color)this.fValue;
                int n = ((Color)object).getAlpha();
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
                figure.setAttribute(this.fAttribute, color);
                continue;
            }
            figure.setAttribute(this.fAttribute, this.fValue);
        }
        drawingView.checkDamage();
        return true;
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }
}

