/*
 * Decompiled with CFR 0.152.
 */
package de.renew.rnrg.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.StatusDisplayer;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.simulator.GraphFinder;
import de.renew.gui.CPNDrawing;
import de.renew.net.Net;
import de.renew.net.NetNotFoundException;
import de.renew.net.TransitionCheckerImpl;
import de.renew.plugin.command.CLCommand;
import de.renew.rnrg.elements.Graph;
import de.renew.rnrg.elements.NodeImpl;
import de.renew.rnrg.gui.GraphDrawing;
import java.io.PrintStream;

public class ReachabilityGraphClCommand
implements CLCommand,
StatusDisplayer {
    public static final String CMD = "reachgraph";

    public void execute(String[] stringArray, PrintStream printStream) {
        String string = stringArray.length == 0 ? null : stringArray[0];
        this.showStatus(ReachabilityGraphClCommand.createGraph(string, 0));
    }

    protected static String createGraph(String string, int n) {
        return ReachabilityGraphClCommand.createGraph(string, n, -1L, new TransitionCheckerImpl(true, false), new Graph.Aborter(){

            @Override
            public boolean abort() {
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String createGraph(String string, int n, long l, GraphFinder.TransitionChecker transitionChecker, Graph.Aborter aborter) {
        DrawApplication drawApplication = DrawPlugin.getGui();
        if (drawApplication == null || !(drawApplication.drawing() instanceof CPNDrawing)) return "no net name given and no cpn drawing open in GUI";
        if (string == null) {
            string = drawApplication.drawing().getName();
        }
        SimulatorPlugin.lock.lock();
        try {
            boolean bl;
            SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
            boolean bl2 = bl = simulatorPlugin.getCurrentEnvironment() == null;
            if (bl) {
                simulatorPlugin.setupSimulation(null);
            }
            try {
                Net net = Net.forName((String)string);
                net.setEarlyTokens(true);
                ReachabilityGraphClCommand.createMultiGraph(net, n, l, transitionChecker, aborter);
                if (!bl) return "";
            }
            catch (NetNotFoundException netNotFoundException) {
                String string2;
                block11: {
                    try {
                        string2 = "net " + string + " not found";
                        if (!bl) break block11;
                    }
                    catch (Throwable throwable) {
                        if (!bl) throw throwable;
                        simulatorPlugin.terminateSimulation();
                        throw throwable;
                    }
                    simulatorPlugin.terminateSimulation();
                }
                SimulatorPlugin.lock.unlock();
                return string2;
            }
            simulatorPlugin.terminateSimulation();
            return "";
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
    }

    protected static void createMultiGraph(Net net, int n, long l, GraphFinder.TransitionChecker transitionChecker, Graph.Aborter aborter) {
        NodeImpl nodeImpl = new NodeImpl(net);
        Graph graph = new Graph(nodeImpl, l, transitionChecker, aborter);
        if (!aborter.abort()) {
            DrawPlugin.getGui().openDrawing((Drawing)new GraphDrawing(graph, n));
        }
    }

    public String getDescription() {
        return "Create and open reachability graph of a reference net.";
    }

    public void showStatus(String string) {
        System.out.println(string);
    }

    public String getArguments() {
        return "[netName]";
    }
}

