/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.ccpn;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.util.Command;
import de.renew.application.NoSimulationException;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.simulator.CCPNSimulation;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.net.NetNotFoundException;
import de.renew.shadow.SyntaxException;
import org.apache.log4j.Logger;

public class CurryReachabilityGraphCommand
extends Command {
    private static Logger logger = Logger.getLogger(CurryReachabilityGraphCommand.class);
    public static final String CMD_NAME = "Curry Reachability Graph";

    public CurryReachabilityGraphCommand() {
        super(CMD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        if (!"Curry Net Compiler".equals(formalismPlugin.getCompiler())) {
            simulatorPlugin.terminateSimulation();
            formalismPlugin.setCompiler("Curry Net Compiler");
        }
        CCPNSimulation cCPNSimulation = (CCPNSimulation)ModeReplacement.getInstance().getSimulation();
        if (simulatorPlugin.isSimulationActive()) {
            cCPNSimulation.requestReachGraph();
        } else {
            try {
                String string = CurryReachabilityGraphCommand.class.getSimpleName() + ": Could not start CCPN process for Curry reachability graph generation";
                DrawApplication drawApplication = DrawPlugin.getGui();
                if (drawApplication != null) {
                    Drawing drawing = drawApplication.drawing();
                    if (drawing instanceof CPNDrawing) {
                        try {
                            cCPNSimulation.minimalInit(drawApplication.drawing().getName());
                            cCPNSimulation.requestReachGraph();
                        }
                        catch (NoSimulationException | NetNotFoundException | SyntaxException throwable) {
                            logger.error((Object)(string + ": " + throwable.getMessage()), throwable);
                        }
                    } else if (drawing instanceof NullDrawing) {
                        logger.error((Object)(string + ": no drawing selected"));
                    } else {
                        logger.error((Object)(string + " of drawing of the class: " + String.valueOf(drawing.getClass())));
                    }
                } else {
                    logger.error((Object)(string + ": no active simulation and no GUI present"));
                }
            }
            finally {
                simulatorPlugin.terminateSimulation();
            }
        }
    }
}

