/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.TimeSet;
import de.renew.net.event.PlaceEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CurryPlaceInstance
extends PlaceInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<CurryToken, Integer> marking = new HashMap<CurryToken, Integer>();

    CurryPlaceInstance(NetInstance netInstance, Place place) {
        super(netInstance, place);
    }

    public void resetMarking() {
        this.lock.lock();
        try {
            this.marking.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addToken(String string, int n) {
        this.lock.lock();
        try {
            this.marking.put(new CurryToken(string), n);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyListeners() {
        PlaceEvent placeEvent = new PlaceEvent(this.netInstance.getInstance(this.place));
        this.listeners.markingChanged(placeEvent);
        this.place.getListenerSet().markingChanged(placeEvent);
    }

    public Set<Object> getDistinctTokens() {
        this.lock.lock();
        try {
            Set<Object> set = this.marking.keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<Object> getDistinctTestableTokens() {
        return this.getDistinctTokens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfTokens() {
        this.lock.lock();
        try {
            int n = 0;
            for (int n2 : this.marking.values()) {
                n += n2;
            }
            int n3 = n;
            return n3;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNumberOfTestedTokens() {
        return 0;
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.marking.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getTokenCount(Object object) {
        this.lock.lock();
        try {
            int n = this.marking.get(object);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TimeSet getFreeTimeSet(Object object) {
        this.lock.lock();
        try {
            TimeSet timeSet = TimeSet.make((double)0.0, (int)this.marking.get(object));
            return timeSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean containsTestedToken(Object object) {
        return false;
    }

    private static class CurryToken
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String str;

        CurryToken(String string) {
            this.str = string;
        }

        public String toString() {
            return this.str;
        }
    }
}

