/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.util.Palette;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.FormalismGuiCreator;
import de.renew.gui.GuiPlugin;
import de.renew.gui.JavaGuiCreator;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FormalismGuiPlugin
extends PluginAdapter
implements FormalismChangeListener {
    public static Logger logger = Logger.getLogger(FormalismGuiPlugin.class);
    private Palette currentPalette;
    private JMenuItem currentMenu;
    private FormalismGuiCreator currentCreator;
    private JMenu _formalismMenu;
    private Map<String, JMenuItem> _menuEntries = new HashMap<String, JMenuItem>();
    private MenuManager _menuManager;
    private Map<String, FormalismGuiCreator> _guicreators = new HashMap<String, FormalismGuiCreator>();

    public FormalismGuiPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public FormalismGuiPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public static FormalismGuiPlugin getCurrent() {
        for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
            if (!(iPlugin instanceof FormalismGuiPlugin)) continue;
            return (FormalismGuiPlugin)iPlugin;
        }
        return null;
    }

    public void init() {
        logger.debug((Object)"initializing FormalismGui");
        JavaGuiCreator javaGuiCreator = new JavaGuiCreator();
        this._guicreators.put("Java Net Compiler", javaGuiCreator);
        this._guicreators.put("Timed Java Compiler", javaGuiCreator.getSequentialJavaGuiCreator());
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        formalismPlugin.addFormalismChangeListener((FormalismChangeListener)this);
        this._formalismMenu = this.createMenu();
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        logger.debug((Object)"adding menu");
        this._menuManager = DrawPlugin.getCurrent().getMenuManager();
        MenuManager.SeparatorFactory separatorFactory = new MenuManager.SeparatorFactory("de.renew.formalism.gui");
        this._menuManager.registerMenu("Simulation", separatorFactory.createSeparator());
        this._menuManager.registerMenu("Simulation", (JMenuItem)this._formalismMenu, "de.renew.formalism.gui.formalisms");
        if (guiPlugin == null) {
            logger.debug((Object)"FormalismGuiPlugin: no GuiPlugin, could not add menu.");
        }
        this.formalismChosen(formalismPlugin.getCompiler());
    }

    public void addGuiConfigurator(String string, FormalismGuiCreator formalismGuiCreator) {
        boolean bl;
        logger.debug((Object)("Adding GUI configurator for " + string));
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        String string2 = formalismPlugin.getCompiler();
        boolean bl2 = bl = string2 != null && string2.equals(string);
        if (bl) {
            this.cleanGui();
        }
        this._guicreators.put(string, formalismGuiCreator);
        if (bl) {
            this.createGuiItems(string2);
        }
    }

    public void removeGuiConfigurator(String string) {
        boolean bl;
        logger.debug((Object)("Removing GUI configurator for " + string));
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        String string2 = formalismPlugin.getCompiler();
        boolean bl2 = bl = string2 != null && string2.equals(string);
        if (bl) {
            this.cleanGui();
        }
        this._guicreators.remove(string);
    }

    private JMenu createMenu() {
        JMenu jMenu = new JMenu("Formalisms");
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        Iterator iterator = formalismPlugin.getKnownFormalisms();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            if (string.equals(formalismPlugin.getCompiler())) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = jCheckBoxMenuItem.getText();
                    logger.debug((Object)("compiler " + string + " has been chosen."));
                    FormalismGuiPlugin.this.formalismChosen(string);
                }
            });
            jMenu.add(jCheckBoxMenuItem);
        }
        return jMenu;
    }

    private void formalismChosen(String string) {
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        formalismPlugin.setCompiler(string);
        this.selectFormalismItem(string);
        this.cleanGui();
        this.createGuiItems(string);
    }

    private void createGuiItems(String string) {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        this.currentCreator = this._guicreators.get(string);
        if (this.currentCreator != null) {
            this.currentPalette = this.currentCreator.createPalette();
            if (this.currentPalette != null) {
                guiPlugin.getPaletteHolder().addPalette(this.currentPalette);
            }
            this.currentMenu = this.currentCreator.createMenu();
            if (this.currentMenu != null) {
                this._menuManager.registerMenu("Simulation", this.currentMenu, "de.renew.formalism.gui.current");
            }
            this.currentCreator.formalismActivated();
        }
    }

    private void cleanGui() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (this.currentCreator != null) {
            this.currentCreator.formalismDeactivated();
            this.currentCreator = null;
        }
        if (this.currentPalette != null) {
            guiPlugin.getPaletteHolder().removePalette(this.currentPalette);
            this.currentPalette = null;
        }
        if (this.currentMenu != null) {
            this._menuManager.unregisterMenu(this.currentMenu);
            this.currentMenu = null;
        }
    }

    private void selectFormalismItem(String string) {
        Component[] componentArray = this._formalismMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[i];
            boolean bl = jCheckBoxMenuItem.getText().equals(string);
            jCheckBoxMenuItem.setSelected(bl);
        }
    }

    public boolean cleanup() {
        FormalismPlugin formalismPlugin = FormalismPlugin.getCurrent();
        formalismPlugin.removeFormalismChangeListener((FormalismChangeListener)this);
        this.cleanGui();
        DrawPlugin.getCurrent().getMenuManager().unregisterMenu((JMenuItem)this._formalismMenu);
        this._formalismMenu = null;
        return true;
    }

    public void formalismChanged(String string, Object object, int n) {
        if (n == 0) {
            logger.debug((Object)("FormalismGuiPlugin: new formalism added: " + string));
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = jCheckBoxMenuItem.getText();
                    logger.debug((Object)("compiler " + string + " has been chosen."));
                    FormalismGuiPlugin.this.formalismChosen(string);
                }
            });
            this._formalismMenu.add(jCheckBoxMenuItem);
            this._menuEntries.put(string, jCheckBoxMenuItem);
        } else if (n == 2) {
            logger.debug((Object)("FormalismGuiPlugin: formalism chosen: " + string));
            this.formalismChosen(string);
        } else if (n == 1) {
            logger.debug((Object)("FormalismGuiPlugin: formalism removed: " + string));
            JMenuItem jMenuItem = this._menuEntries.get(string);
            if (jMenuItem != null) {
                this._formalismMenu.remove(jMenuItem);
                this._menuEntries.remove(string);
            }
        }
    }
}

