/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.util.ColorMap;
import de.renew.application.Util;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InscribableFigure;
import de.renew.gui.TextFigureCreator;
import de.renew.net.NetInstance;
import java.awt.Point;
import java.net.URI;

class CPNSelectionTool
extends SelectionTool {
    public CPNSelectionTool(CPNApplication cPNApplication) {
        super((DrawingEditor)cPNApplication);
    }

    protected boolean alternateInspectFigure(Figure figure) {
        if (figure instanceof InscribableFigure) {
            this.editor().prepareUndoSnapshot();
            InscribableFigure inscribableFigure = (InscribableFigure)figure;
            if (inscribableFigure instanceof LineConnection && inscribableFigure.children().hasMoreElements()) {
                inscribableFigure.children().nextFigure().inspect(this.view(), true);
                return true;
            }
            TextFigureCreator textFigureCreator = GuiPlugin.getCurrent().getTextFigureCreator();
            TextFigure textFigure = textFigureCreator.createTextFigure(inscribableFigure);
            textFigure.setParent((ParentFigure)inscribableFigure);
            Point point = this.view().lastClick();
            textFigure.displayBox(point, new Point(point.x + 10, point.y + 10));
            textFigure.setText(textFigureCreator.getDefaultInscription(inscribableFigure));
            textFigure.setAttribute("TextType", (Object)new Integer(1));
            if (inscribableFigure instanceof LineConnection) {
                textFigure.setAttribute("FillColor", (Object)ColorMap.BACKGROUND);
            }
            this.drawing().add((Figure)textFigure);
            this.view().clearSelection();
            this.view().addToSelection((Figure)textFigure);
            this.editor().commitUndoSnapshot();
            return true;
        }
        return super.alternateInspectFigure(figure);
    }

    public void simAccess(URI uRI) {
        Util util = new Util();
        NetInstance netInstance = util.findInstance("" + uRI.getPort());
        if (netInstance == null) {
            return;
        }
        util.fireTransition(netInstance, uRI.getPath());
    }
}

