/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.converter;

import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.converter.PTNetConverter;
import de.renew.gui.pnml.converter.RefNetConverter;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetSystem;
import org.apache.log4j.Logger;

public class Converter {
    private static Logger logger = Logger.getLogger(Converter.class);
    private String _netType;
    private boolean _toolInsc;
    private ShadowNet net;

    public Converter(String string) {
        this(string, false);
    }

    public Converter(String string, boolean bl) {
        this._netType = string;
        this._toolInsc = bl;
    }

    public String getType() {
        return this._netType;
    }

    public String getNetID() {
        return this.net.getName();
    }

    protected ShadowNet getShadowNet() {
        return this.net;
    }

    public void setShadowNet(CPNDrawing cPNDrawing) {
        if (RefNetConverter.isNetParser(this._netType)) {
            FormalismPlugin.getCurrent().setCompiler("Java Net Compiler");
        }
        this.net = cPNDrawing.buildShadow(new ShadowNetSystem(ModeReplacement.getInstance().getDefaultCompilerFactory()));
    }

    public NetConverter getNetConverter() {
        if (this._netType != null) {
            if (RefNetConverter.isNetParser(this._netType)) {
                return new RefNetConverter(this, this._toolInsc);
            }
            if (!PTNetConverter.isNetParser(this._netType)) {
                logger.warn((Object)(Converter.class.getSimpleName() + ": unknown PNML net type: " + this._netType));
            }
        }
        return new PTNetConverter(this, this._toolInsc);
    }
}

