/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.tree;

import java.io.IOException;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gitective.core.filter.tree.BaseTreeFilter;

public class TypeCountFilter
extends BaseTreeFilter {
    private final int type;
    private long count;

    public static TypeCountFilter submodule() {
        return new TypeCountFilter(57344);
    }

    public static TypeCountFilter file() {
        return new TypeCountFilter(32768);
    }

    public static TypeCountFilter symlink() {
        return new TypeCountFilter(40960);
    }

    public static TypeCountFilter tree() {
        return new TypeCountFilter(16384);
    }

    public TypeCountFilter(int type) {
        this.type = type;
    }

    public long getCount() {
        return this.count;
    }

    public int getType() {
        return this.type;
    }

    public BaseTreeFilter reset() {
        this.count = 0L;
        return super.reset();
    }

    public boolean include(TreeWalk walker) throws IOException {
        if (this.type == (walker.getRawMode(0) & 0xF000)) {
            ++this.count;
        }
        return true;
    }

    public TreeFilter clone() {
        return new TypeCountFilter(this.type);
    }
}

