/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.VersionControl;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractVersionControl
implements VersionControl {
    public static final Logger logger = Logger.getLogger(AbstractVersionControl.class);
    private static final HashMap<File, Repository> REPOSITORIES = new HashMap();

    @Override
    public final boolean controls(File file) {
        return REPOSITORIES.containsKey(file) || this.findRepository(file) != null;
    }

    @Override
    public final Repository findRepository(File file) {
        if (REPOSITORIES.containsKey(file)) {
            return REPOSITORIES.get(file);
        }
        File file2 = this.findRootDirectory(file);
        if (file2 == null) {
            logger.warn((Object)(String.valueOf(file) + " belongs not to " + this.getName()));
            return null;
        }
        if (REPOSITORIES.containsKey(file2)) {
            Repository repository = REPOSITORIES.get(file2);
            REPOSITORIES.put(file, repository);
            return repository;
        }
        Repository repository = this.buildRepository(file);
        if (repository == null) {
            logger.warn((Object)(String.valueOf(file) + " belongs not to " + this.getName()));
            return null;
        }
        REPOSITORIES.put(file, repository);
        REPOSITORIES.put(repository.getRootDirectory(), repository);
        logger.debug((Object)("Found " + String.valueOf(file) + ", belongs to " + this.getName()));
        return repository;
    }

    @Override
    public String getName() {
        String string = this.getClass().getSimpleName();
        int n = string.indexOf("VersionControl");
        return n == -1 ? string : string.substring(0, n);
    }

    protected abstract File findRootDirectory(File var1);

    protected abstract Repository buildRepository(File var1);

    protected void errorException(Exception exception, String string) {
        logger.error((Object)("Error while " + string), (Throwable)exception);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getClass().getSimpleName() + ": " + String.valueOf(exception)));
        }
    }
}

