/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.models.TreeElement;
import de.renew.navigator.vc.Repository;
import java.awt.Color;
import java.awt.Font;
import java.util.Set;
import javax.swing.tree.DefaultTreeCellRenderer;

class RepositoryTreeCellRenderer
extends FileTreeCellRenderer {
    private final Set<Repository> repositories;
    public static final Color MODIFIED_COLOR = new Color(0, 51, 153);
    public static final Color ADDED_COLOR = new Color(0, 102, 0);

    public RepositoryTreeCellRenderer(Set<Repository> set) {
        this.repositories = set;
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, TreeElement treeElement, boolean bl, boolean bl2) {
        for (Repository repository : this.repositories) {
            if (repository.getRootDirectory().equals(treeElement.getFile())) {
                defaultTreeCellRenderer.setText(treeElement.getFile().getName() + " @ " + repository.getBranch());
            }
            if (repository.getIgnored().contains(treeElement.getFile())) {
                defaultTreeCellRenderer.setForeground(new Color(150, 150, 150));
                defaultTreeCellRenderer.setText(defaultTreeCellRenderer.getText());
                return;
            }
            boolean bl3 = repository.getModified().contains(treeElement.getFile());
            boolean bl4 = repository.getAdded().contains(treeElement.getFile());
            if (bl3 || bl4) {
                defaultTreeCellRenderer.setFont(new Font(defaultTreeCellRenderer.getFont().getName(), 1, defaultTreeCellRenderer.getFont().getSize()));
                defaultTreeCellRenderer.setText(defaultTreeCellRenderer.getText() + " - ");
            }
            if (bl3) {
                defaultTreeCellRenderer.setText(defaultTreeCellRenderer.getText() + "M");
                defaultTreeCellRenderer.setForeground(MODIFIED_COLOR);
            }
            if (!bl4) continue;
            defaultTreeCellRenderer.setText(defaultTreeCellRenderer.getText() + "A");
            defaultTreeCellRenderer.setForeground(ADDED_COLOR);
        }
    }
}

