/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc.git;

import de.renew.navigator.vc.AbstractRepository;
import de.renew.navigator.vc.Commit;
import de.renew.navigator.vc.VersionControl;
import de.renew.navigator.vc.git.GitVersionControl;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;

public class GitRepository
extends AbstractRepository {
    public static final Logger logger = Logger.getLogger(GitRepository.class);
    protected final Git git;
    protected final FileRepository fileRepository;

    public GitRepository(FileRepository fileRepository, GitVersionControl gitVersionControl) {
        super(fileRepository.getWorkTree(), (VersionControl)gitVersionControl);
        this.fileRepository = fileRepository;
        this.git = new Git((Repository)fileRepository);
        this.lastCommit = this.retrieveLastCommit();
        this.update();
    }

    public String getBranch() {
        try {
            return this.fileRepository.getBranch();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getRemoteURL() {
        FileBasedConfig fileBasedConfig = this.fileRepository.getConfig();
        Set set = fileBasedConfig.getSubsections("remote");
        Set set2 = fileBasedConfig.getSubsections("svn-remote");
        HashSet<String> hashSet = new HashSet<String>(set.size() + set2.size());
        for (String string : set) {
            hashSet.add(fileBasedConfig.getString("remote", string, "url"));
        }
        for (String string : set2) {
            hashSet.add(fileBasedConfig.getString("svn-remote", string, "url"));
        }
        return StringUtil.join(hashSet, (String)",");
    }

    public void update() {
        this.modified.clear();
        this.added.clear();
        this.ignored.clear();
        try {
            Status status = this.git.status().call();
            this.modified.addAll(this.makeFileSet(status.getModified(), true));
            this.added.addAll(this.makeFileSet(status.getAdded(), false));
            this.ignored.addAll(this.makeFileSet(status.getUntracked(), false));
        }
        catch (GitAPIException gitAPIException) {
            // empty catch block
        }
    }

    protected Commit retrieveLastCommit() {
        try {
            Iterator iterator = this.git.log().call().iterator();
            if (iterator.hasNext()) {
                RevCommit revCommit = (RevCommit)iterator.next();
                Commit commit = new Commit();
                commit.setAuthor(revCommit.getAuthorIdent().getName());
                commit.setDate(revCommit.getCommitTime());
                commit.setMessage(revCommit.getFullMessage());
                commit.setRevision(revCommit.getName());
                return commit;
            }
        }
        catch (GitAPIException gitAPIException) {
            logger.error((Object)"Could not get last commit", (Throwable)gitAPIException);
        }
        return null;
    }

    private Set<File> makeFileSet(Set<String> set, boolean bl) {
        HashSet<File> hashSet = new HashSet<File>();
        String string = this.getRootDirectory().getAbsolutePath();
        File file = new File(string);
        for (String string2 : set) {
            String string3 = string + File.separatorChar + string2;
            File file2 = new File(string3);
            if (!file2.exists()) continue;
            do {
                hashSet.add(file2);
                file2 = file2.getParentFile();
            } while (bl && !file2.equals(file));
        }
        return hashSet;
    }
}

