/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc.git;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.util.StorableInput;
import de.renew.imagenetdiff.PNGDiffCommand;
import de.renew.logging.CliColor;
import de.renew.navigator.vc.AbstractVersionControl;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.StdoutStatusDisplayer;
import de.renew.navigator.vc.git.GitRepository;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gitective.core.BlobUtils;

public class GitVersionControl
extends AbstractVersionControl {
    public boolean diff(File file) {
        logger.debug((Object)("diff with head: " + file.getAbsolutePath()));
        try {
            String string;
            GitRepository gitRepository = this.buildGitRepository(file);
            URI uRI = gitRepository.makeRelativeURI(file);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Git Repository Branch:  " + gitRepository.getBranch()));
                logger.debug((Object)("Git file path:          " + file.getPath()));
                logger.debug((Object)("Git relative file path: " + uRI.getPath()));
            }
            if ((string = BlobUtils.getContent((org.eclipse.jgit.lib.Repository)gitRepository.fileRepository, (String)"HEAD", (String)uRI.getPath())) == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Git: There is no HEAD here. File possibly not in repository. Received null.");
                }
                return false;
            }
            Drawing drawing = StorableInputDrawingLoader.readStorableDrawing((StorableInput)new StorableInput(string));
            StdoutStatusDisplayer stdoutStatusDisplayer = new StdoutStatusDisplayer();
            Drawing drawing2 = DrawingFileHelper.loadDrawing((File)file.getAbsoluteFile(), (StatusDisplayer)stdoutStatusDisplayer);
            if (drawing2 == null) {
                logger.warn((Object)("Something went wrong. Given Drawing could not be loaded: " + drawing.getName()));
                return false;
            }
            drawing.setName(drawing2.getName() + "[HEAD]");
            PNGDiffCommand pNGDiffCommand = new PNGDiffCommand();
            pNGDiffCommand.doDiff((StatusDisplayer)stdoutStatusDisplayer, drawing, drawing2, false);
            return true;
        }
        catch (AmbiguousObjectException ambiguousObjectException) {
            this.errorException((Exception)((Object)ambiguousObjectException), "performing diff with head");
        }
        catch (MissingObjectException missingObjectException) {
            this.errorException((Exception)((Object)missingObjectException), "performing diff with head");
        }
        catch (IncorrectObjectTypeException incorrectObjectTypeException) {
            this.errorException((Exception)((Object)incorrectObjectTypeException), "performing diff with head");
        }
        catch (IOException iOException) {
            this.errorException(iOException, "performing diff with head");
        }
        return false;
    }

    public boolean log(File file) {
        try {
            boolean bl = false;
            GitRepository gitRepository = this.buildGitRepository(file);
            LogCommand logCommand = gitRepository.git.log();
            URI uRI = gitRepository.makeRelativeURI(file);
            logger.info((Object)("Branch: " + gitRepository.getBranch() + " File: " + String.valueOf(uRI) + "\n Revisions: "));
            Iterable iterable = logCommand.addPath(uRI.getPath()).call();
            for (RevCommit revCommit : iterable) {
                System.out.println("\n\n" + CliColor.color((String)revCommit.toString(), (CliColor[])new CliColor[]{CliColor.BLUE}) + "\n" + CliColor.color((String)("Author: " + revCommit.getAuthorIdent().getEmailAddress() + "\nDate:   " + String.valueOf(revCommit.getAuthorIdent().getWhen())), (CliColor[])new CliColor[]{CliColor.WHITE}) + "\n\n" + revCommit.getFullMessage().replaceAll("(?m)^", "\t"));
                bl = true;
            }
            return bl;
        }
        catch (NoHeadException noHeadException) {
            noHeadException.printStackTrace();
        }
        catch (GitAPIException gitAPIException) {
            gitAPIException.printStackTrace();
        }
        return false;
    }

    public File findRootDirectory(File file2) {
        FileRepositoryBuilder fileRepositoryBuilder = new FileRepositoryBuilder();
        ((FileRepositoryBuilder)((FileRepositoryBuilder)fileRepositoryBuilder.findGitDir(file2)).setMustExist(true)).readEnvironment();
        return Optional.ofNullable(fileRepositoryBuilder.getGitDir()).map(file -> file.getParentFile()).orElse(null);
    }

    protected Repository buildRepository(File file) {
        return this.buildGitRepository(file);
    }

    protected GitRepository buildGitRepository(File file) {
        logger.debug((Object)("Locating Git repository for [" + String.valueOf(file) + "]"));
        FileRepositoryBuilder fileRepositoryBuilder = new FileRepositoryBuilder();
        ((FileRepositoryBuilder)((FileRepositoryBuilder)fileRepositoryBuilder.findGitDir(file)).setMustExist(true)).readEnvironment();
        if (null == fileRepositoryBuilder.getGitDir()) {
            logger.debug((Object)("This is not in a Git repo   [" + String.valueOf(file) + "]"));
            return null;
        }
        try {
            FileRepository fileRepository = fileRepositoryBuilder.build();
            System.out.println(fileRepository);
            return new GitRepository(fileRepository, this);
        }
        catch (IOException iOException) {
            logger.error((Object)"Unable to locate Git repo", (Throwable)iOException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)"Unable to locate Git repo", (Throwable)illegalArgumentException);
            return null;
        }
    }

    public boolean displayListForFile(File file) {
        try {
            boolean bl = false;
            GitRepository gitRepository = this.buildGitRepository(file);
            LogCommand logCommand = gitRepository.git.log();
            URI uRI = gitRepository.makeRelativeURI(file);
            logger.info((Object)("Branch: " + gitRepository.getBranch()));
            logger.info((Object)("File:   " + String.valueOf(uRI)));
            Iterable iterable = logCommand.addPath(uRI.getPath()).call();
            for (RevCommit revCommit : iterable) {
                logger.info((Object)("Revisions: " + revCommit.toString()));
                bl = true;
            }
            return bl;
        }
        catch (NoHeadException noHeadException) {
            noHeadException.printStackTrace();
        }
        catch (GitAPIException gitAPIException) {
            gitAPIException.printStackTrace();
        }
        return false;
    }
}

