/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import de.renew.refactoring.search.range.SearchRange;
import de.renew.refactoring.wizard.WrapLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.log4j.Logger;

public class SearchRangeSelectPanel
extends JPanel {
    private static final long serialVersionUID = -4669316167221128799L;
    private static Logger logger = Logger.getLogger(SearchRangeSelectPanel.class);
    private Map<JRadioButton, SearchRange> _buttons;

    public SearchRangeSelectPanel(List<SearchRange> list) {
        this(list, list.size() - 1);
    }

    public SearchRangeSelectPanel(List<SearchRange> list, int n) {
        this.createRadioButtons(list, n);
        this.setLayout(new WrapLayout());
    }

    private void createRadioButtons(List<SearchRange> list, int n) {
        JLabel jLabel = new JLabel("Search Range:");
        this.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._buttons = new HashMap<JRadioButton, SearchRange>();
        int n2 = 0;
        for (SearchRange searchRange : list) {
            JRadioButton jRadioButton = new JRadioButton(searchRange.description());
            jRadioButton.setSelected(n2 == n);
            this._buttons.put(jRadioButton, searchRange);
            this.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            ++n2;
        }
    }

    public SearchRange getValue() {
        for (JRadioButton jRadioButton : this._buttons.keySet()) {
            if (!jRadioButton.isSelected()) continue;
            return this._buttons.get(jRadioButton);
        }
        return null;
    }
}

