/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import de.renew.refactoring.wizard.WizardButtons;
import de.renew.refactoring.wizard.WizardController;
import de.renew.refactoring.wizard.WizardListener;
import de.renew.refactoring.wizard.WizardPage;
import de.renew.refactoring.wizard.WizardPageStack;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
extends WindowAdapter
implements ActionListener,
WizardButtons {
    private static final String PREVIOUS_BUTTON_ACTION_COMMAND = "PREVIOUS";
    private static final String NEXT_BUTTON_ACTION_COMMAND = "NEXT";
    private static final String CANCEL_BUTTON_ACTION_COMMAND = "CANCEL";
    private JDialog _dialog;
    private JPanel _pagePanel;
    private WizardPageStack _pages = new WizardPageStack();
    private WizardController _controller;
    private Set<WizardListener> _listeners = new HashSet<WizardListener>();
    private JButton _previousButton;
    private JButton _nextButton;
    private JButton _cancelButton;
    private boolean _nextButtonFinish = false;

    public Wizard(WizardController wizardController) {
        this._controller = wizardController;
        this._controller.setWizardButtons(this);
        this.initComponents(this._controller.getTitle());
        this.start();
    }

    private void start() {
        this.showNextPage();
        this._dialog.setVisible(true);
    }

    public boolean addListener(WizardListener wizardListener) {
        return this._listeners.add(wizardListener);
    }

    public boolean removeListener(WizardListener wizardListener) {
        return this._listeners.remove(wizardListener);
    }

    private void initComponents(String string) {
        this._dialog = new JDialog();
        this._dialog.setTitle(string);
        this._dialog.setSize(500, 500);
        this._dialog.setMinimumSize(new Dimension(300, 300));
        this._dialog.getContentPane().setLayout(new BorderLayout());
        this._dialog.addWindowListener(this);
        JPanel jPanel = new JPanel();
        Box box = new Box(0);
        this._pagePanel = new JPanel();
        this._pagePanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this._pagePanel.setLayout(new CardLayout());
        this._previousButton = new JButton("Back");
        this._nextButton = new JButton("Next");
        this._cancelButton = new JButton("Cancel");
        this._previousButton.setActionCommand(PREVIOUS_BUTTON_ACTION_COMMAND);
        this._nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this._cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this._previousButton.addActionListener(this);
        this._nextButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JSeparator(), "North");
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(this._previousButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this._nextButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this._cancelButton);
        jPanel.add((Component)box, "East");
        this._dialog.getContentPane().add((Component)jPanel, "South");
        this._dialog.getContentPane().add((Component)this._pagePanel, "Center");
        this._dialog.getRootPane().setDefaultButton(this._nextButton);
    }

    private void showNextPage() {
        this.save();
        WizardPage wizardPage = this._controller.getNextPage();
        if (wizardPage == null) {
            return;
        }
        wizardPage.didLoad();
        this._pages.push(wizardPage);
        this._pagePanel.add((Component)wizardPage.getPanel(), wizardPage.getId());
        this.configureForPage(wizardPage);
    }

    private void save() {
        WizardPage wizardPage = this.getCurrentPage();
        if (wizardPage != null) {
            wizardPage.saveState();
            wizardPage.willDisappear();
        }
    }

    private void showPreviousPage() {
        this.popCurrentPage();
        this.configureForPage(this.getCurrentPage());
    }

    private void popCurrentPage() {
        WizardPage wizardPage = this.getCurrentPage();
        wizardPage.resetState();
        wizardPage.willDisappear();
        this._pages.pop();
        this._pagePanel.remove(wizardPage.getPanel());
    }

    private void cancel() {
        while (this._pages.size() > 0) {
            this.popCurrentPage();
        }
        this.dispose();
    }

    private void dispose() {
        this.informListeners();
        this._dialog.dispose();
    }

    private void configureForPage(WizardPage wizardPage) {
        this._pagePanel.revalidate();
        ((CardLayout)this._pagePanel.getLayout()).show(this._pagePanel, wizardPage.getId());
        this.internalSetPreviousButtonEnabled(this._pages.size() > 1);
        this.setNextButtonTitleToFinish(wizardPage.isLastPage());
        String string = wizardPage.nextButtonTitle();
        if (string != null) {
            this.setNextButtonTitle(string);
        }
        wizardPage.internalDidAppear();
    }

    private WizardPage getCurrentPage() {
        return this._pages.peek();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    private void informListeners() {
        for (WizardListener wizardListener : this._listeners) {
            wizardListener.wizardFinished();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(PREVIOUS_BUTTON_ACTION_COMMAND)) {
            this.backButtonPressed();
        } else if (actionEvent.getActionCommand().equals(NEXT_BUTTON_ACTION_COMMAND)) {
            if (this._nextButtonFinish) {
                this.finishButtonPressed();
            } else {
                this.nextButtonPressed();
            }
        } else if (actionEvent.getActionCommand().equals(CANCEL_BUTTON_ACTION_COMMAND)) {
            this.cancelButtonPressed();
        }
    }

    private void backButtonPressed() {
        this.showPreviousPage();
    }

    private void nextButtonPressed() {
        this.showNextPage();
    }

    private void finishButtonPressed() {
        this.save();
        this.dispose();
    }

    private void cancelButtonPressed() {
        this.cancel();
    }

    private void internalSetPreviousButtonEnabled(boolean bl) {
        this._previousButton.setEnabled(bl);
    }

    @Override
    public void setPreviousButtonEnabled(boolean bl) {
        if (bl) {
            return;
        }
        this._previousButton.setEnabled(false);
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this._nextButton.setEnabled(bl);
    }

    @Override
    public void focusNextButton() {
        this._nextButton.requestFocusInWindow();
    }

    private void setNextButtonTitleToFinish(boolean bl) {
        this._nextButtonFinish = bl;
        this._nextButton.setText(bl ? "Finish" : "Next");
    }

    private void setNextButtonTitle(String string) {
        this._nextButton.setText(string);
    }
}

