/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.ConfigureSimulationController;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class ConfigureSimulationDialog
extends JDialog {
    private JPanel buttonPanel;
    private JButton applyButton;
    private JButton updateButton;
    private JButton updateSimButton;
    private JButton okButton;
    private JButton closeButton;
    private JTabbedPane optionsTabbedPane;
    private JLabel noteLabel;
    private final ConfigureSimulationController controller;

    public ConfigureSimulationDialog(JFrame jFrame, ConfigureSimulationController configureSimulationController, Component[] componentArray) {
        super((Frame)jFrame, false);
        this.controller = configureSimulationController;
        this.initComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.optionsTabbedPane.add(componentArray[i]);
        }
        this.pack();
    }

    private void initComponents() {
        this.noteLabel = new JLabel();
        this.optionsTabbedPane = new JTabbedPane();
        this.buttonPanel = new JPanel();
        this.applyButton = new JButton();
        this.updateButton = new JButton();
        this.updateSimButton = new JButton();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.setName("Configure Simulation");
        this.setTitle("Configure Simulation");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ConfigureSimulationDialog.this.controller.closeDialog();
            }
        });
        this.noteLabel.setText("Settings will not take effect until a new simulation is set up.");
        this.getContentPane().add((Component)this.noteLabel, "North");
        this.getContentPane().add((Component)this.optionsTabbedPane, "Center");
        this.applyButton.setText("Apply");
        this.applyButton.setToolTipText("Confirms these settings for the next simulation setup and closes the dialog.");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureSimulationDialog.this.controller.commitDialog();
            }
        });
        this.buttonPanel.add(this.applyButton);
        this.updateButton.setToolTipText("Copies the current settings of the simulator plugin into this dialog.");
        this.updateButton.setText("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureSimulationDialog.this.controller.updateDialog();
            }
        });
        this.buttonPanel.add(this.updateButton);
        this.updateSimButton.setToolTipText("Copies the settings of the current simulation into this dialog.");
        this.updateSimButton.setText("Update from Simulation");
        this.updateSimButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureSimulationDialog.this.controller.updateDialogFromSimulation();
            }
        });
        this.buttonPanel.add(this.updateSimButton);
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Confirms these settings for the next simulation setup and closes the dialog.");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureSimulationDialog.this.controller.commitDialog();
                ConfigureSimulationDialog.this.controller.closeDialog();
            }
        });
        this.buttonPanel.add(this.okButton);
        this.closeButton.setToolTipText("Closes the dialog without changing the settings.");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureSimulationDialog.this.controller.closeDialog();
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void addOptionsTab(Component component) {
        this.optionsTabbedPane.add(component);
    }

    public void removeOptionsTab(Component component) {
        this.optionsTabbedPane.remove(component);
    }

    public void removeAllOptionTabs() {
        this.optionsTabbedPane.removeAll();
    }
}

