/*
 * Decompiled with CFR 0.152.
 */
package de.renew.console;

import de.renew.console.completer.CompleterComposition;
import de.renew.console.completer.DrawingsCompleter;
import de.renew.console.completer.FirstWhitespaceArgumentDelimiter;
import de.renew.console.completer.LocationsCompleter;
import de.renew.console.completer.PluginCompleter;
import de.renew.console.completer.PropertyCompleter;
import de.renew.console.completer.RenewArgumentCompleter;
import de.renew.plugin.CommandsListener;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.SoftDependency;
import de.renew.plugin.command.CLCommand;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.log4j.Logger;

public class ConsolePlugin
extends PluginAdapter
implements CommandsListener {
    private static final String COLOR_PROP_NAME = "de.renew.console.color";
    private static final String DRAWING_NAMES = "drawingNames";
    private static final String PROPERTY_NAMES = "propertyNames";
    private static final String LOCATION_NAMES = "locationNames";
    private static final String PLUGIN_NAMES = "pluginNames";
    private static final String FILE_NAMES = "fileNames";
    public static Logger logger = Logger.getLogger(ConsolePlugin.class);
    public static final String DONT_PROP_NAME = "de.renew.console.dont";
    public static final String ALIVE_PROP_NAME = "de.renew.console.keepalive";
    private boolean coloredPrompt = false;
    private PromptThread _promptThread;
    private boolean blockingState = false;
    private Map<String, Completer> completers = new HashMap<String, Completer>();
    private CountDownLatch latch;
    private boolean promtThreadReady = false;
    private SoftDependency chDependency;

    public ConsolePlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public ConsolePlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public synchronized void init() {
        boolean bl;
        boolean bl2 = bl = !this.getProperties().getBoolProperty(DONT_PROP_NAME);
        if (bl) {
            this.latch = new CountDownLatch(1);
            this.prompt();
            this.setBlockingState(this.getProperties().getBoolProperty(ALIVE_PROP_NAME));
            PluginManager pluginManager = PluginManager.getInstance();
            pluginManager.addCommandListener((CommandsListener)this);
            this.coloredPrompt = this.getProperties().getBoolProperty(COLOR_PROP_NAME);
            for (Map.Entry entry : pluginManager.getCLCommands().entrySet()) {
                String string = (String)entry.getKey();
                CLCommand cLCommand = (CLCommand)entry.getValue();
                this.commandAdded(string, cLCommand);
            }
            pluginManager.addCLCommand("keepalive", (CLCommand)new BlockingPromptCommand());
        } else {
            logger.debug((Object)"ConsolePlugin: de.renew.console.dont is set to true. Not prompting.");
        }
        this.chDependency = new SoftDependency((IPlugin)this, "ch.ifa.draw", "de.renew.console.CHDependencyListener");
    }

    public synchronized boolean cleanup() {
        if (this._promptThread != null) {
            logger.debug((Object)("shutting down prompt thread " + String.valueOf(this._promptThread)));
            this._promptThread.setStop();
            PluginManager.getInstance().removeCLCommand("keepalive");
            this._promptThread = null;
        }
        PluginManager pluginManager = PluginManager.getInstance();
        pluginManager.removeCLCommand("keepalive");
        pluginManager.removeCLCommand("reinit");
        pluginManager.removeCommandListener((CommandsListener)this);
        if (this.chDependency != null) {
            this.chDependency.discard();
            this.chDependency = null;
        }
        return true;
    }

    private void prompt() {
        this._promptThread = new PromptThread();
        this._promptThread.start();
    }

    public synchronized void setBlockingState(boolean bl) {
        if (bl != this.blockingState) {
            this.blockingState = bl;
            if (this.blockingState) {
                this.registerExitBlock();
            } else {
                this.registerExitOk();
            }
        }
    }

    public void commandAdded(String string, CLCommand cLCommand) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + ConsolePlugin.class.getSimpleName() + "]: Command added: " + string + " " + cLCommand.getClass().getSimpleName()));
        }
        String string2 = cLCommand.getArguments();
        String[] stringArray = null;
        if (string2 != null) {
            stringArray = string2.replaceAll(" +", " ").split(" ");
        }
        Completer completer = this.getCompleterForCommand(string, stringArray);
        if (!this.promtThreadReady) {
            try {
                logger.debug((Object)("[" + ConsolePlugin.class.getSimpleName() + "]: Waiting for Prompt thread."));
                this.latch.await();
                this.promtThreadReady = true;
                logger.debug((Object)("[" + ConsolePlugin.class.getSimpleName() + "]: Prompt thread ready."));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._promptThread.ac.addCompleter(completer);
        this.completers.put(string, completer);
    }

    public void commandRemoved(String string) {
        if (this._promptThread != null && this._promptThread.ac != null) {
            this._promptThread.ac.removeCompleter(this.completers.remove(string));
        }
    }

    private Completer getCompleterForCommand(String string, String[] stringArray) {
        Object object = new NullCompleter();
        if (stringArray != null) {
            NullCompleter nullCompleter = new NullCompleter();
            for (int i = stringArray.length - 1; i >= 0; --i) {
                Object object2;
                Object object3;
                String string2 = stringArray[i];
                boolean bl = string2.matches("\\[.*\\]\\*?");
                boolean bl2 = string2.matches("\\(.*\\)\\*?");
                boolean bl3 = false;
                if (bl || bl2) {
                    if (string2.matches(".*\\*")) {
                        string2 = string2.substring(1, string2.length() - 2);
                        bl3 = true;
                    } else {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    object3 = string2.split("\\|");
                    ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                    ArrayList<Completer> arrayList2 = new ArrayList<Completer>();
                    for (String string3 : object3) {
                        if (this.isKeyword(string3)) {
                            arrayList2.add(this.getCompleterForKeyword(string3));
                            continue;
                        }
                        arrayList.add((CallSite)((Object)(string3 + " ")));
                    }
                    if (arrayList.size() > 0) {
                        arrayList2.add((Completer)new StringsCompleter(arrayList));
                    }
                    object2 = new CompleterComposition(arrayList2);
                } else {
                    object2 = this.isKeyword(string2) ? this.getCompleterForKeyword(string2) : new StringsCompleter(new String[]{string2 + " "});
                }
                if (bl3) {
                    object3 = new CompleterComposition(new Completer[]{nullCompleter});
                    object = new RenewArgumentCompleter((RenewArgumentCompleter.ArgumentDelimiter)new FirstWhitespaceArgumentDelimiter(), new Completer[]{object2, object3});
                    ((CompleterComposition)object3).addCompleter((Completer)object);
                } else {
                    object = new RenewArgumentCompleter((RenewArgumentCompleter.ArgumentDelimiter)new FirstWhitespaceArgumentDelimiter(), new Completer[]{object2, nullCompleter});
                }
                if (bl) {
                    object = new AggregateCompleter(new Completer[]{object, nullCompleter});
                }
                nullCompleter = object;
            }
        }
        return new RenewArgumentCompleter((RenewArgumentCompleter.ArgumentDelimiter)new FirstWhitespaceArgumentDelimiter(), new Completer[]{new StringsCompleter(new String[]{string + " "}), object});
    }

    private Completer getCompleterForKeyword(String string) {
        Object object = string.equals(FILE_NAMES) ? new FileNameCompleter() : (string.equals(PLUGIN_NAMES) ? new PluginCompleter() : (string.equals(LOCATION_NAMES) ? new LocationsCompleter() : (string.equals(PROPERTY_NAMES) ? new PropertyCompleter() : (string.equals(DRAWING_NAMES) ? new DrawingsCompleter() : new NullCompleter()))));
        return object;
    }

    private boolean isKeyword(String string) {
        return string.equals(FILE_NAMES) || string.equals(PLUGIN_NAMES) || string.equals(LOCATION_NAMES) || string.equals(PROPERTY_NAMES) || string.equals(DRAWING_NAMES);
    }

    private class BlockingPromptCommand
    implements CLCommand {
        private BlockingPromptCommand() {
        }

        public void execute(String[] stringArray, PrintStream printStream) {
            if (stringArray.length == 0) {
                if (ConsolePlugin.this.blockingState) {
                    printStream.println("Prompt will keep plugin system alive.");
                } else {
                    printStream.println("Prompt will not prevent plugin system from automatic termination.");
                }
            } else if ("on".equals(stringArray[0])) {
                ConsolePlugin.this.setBlockingState(true);
                printStream.println("Prompt will keep plugin system alive.");
            } else if ("off".equals(stringArray[0])) {
                ConsolePlugin.this.setBlockingState(false);
                printStream.println("Prompt will not prevent plugin system from automatic termination.");
            } else {
                printStream.println("Controls the keep-alive feature of the Renew Prompt plugin.\nArguments:\n - \"on\" prevents the plugin system from automatic termination.\n - \"off\" allows automatic termination as long as no other plugin prevents it.\n - no argument displays the current keep-alive mode.");
            }
        }

        public String getDescription() {
            return "controls the keep-alive feature of the Renew Prompt plugin.";
        }

        public String getArguments() {
            return null;
        }
    }

    private class PromptThread
    extends Thread {
        private static final String HISTORY_PROPS = "history.props";
        private boolean _stop;
        private ConsoleReader reader;
        private File prefsFile;
        private CompleterComposition ac;

        public PromptThread() {
            super("Plugin-Prompt-Thread");
            this._stop = false;
            this.prefsFile = null;
            this.ac = new CompleterComposition();
            File file = PluginManager.getPreferencesLocation();
            this.prefsFile = new File(file, HISTORY_PROPS);
        }

        @Override
        public void run() {
            block20: {
                logger.debug((Object)"Prompt thread running.");
                this._stop = false;
                try {
                    PrintWriter printWriter;
                    String string;
                    block19: {
                        this.reader = new ConsoleReader();
                        CompletionHandler completionHandler = this.reader.getCompletionHandler();
                        if (completionHandler instanceof CandidateListCompletionHandler) {
                            ((CandidateListCompletionHandler)completionHandler).setPrintSpaceAfterFullCompletion(false);
                        }
                        this.reader.setPrompt(this.getPrompt());
                        FileHistory fileHistory = new FileHistory(this.prefsFile);
                        this.reader.setHistory((History)fileHistory);
                        this.reader.addCompleter((Completer)this.ac);
                        string = null;
                        printWriter = new PrintWriter(this.reader.getOutput());
                        ConsolePlugin.this.latch.countDown();
                        try {
                            string = this.reader.readLine();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            logger.error((Object)("Illegal agrument: " + illegalArgumentException.getMessage()));
                            if (!logger.isDebugEnabled()) break block19;
                            logger.debug((Object)(PromptThread.class.getSimpleName() + ": " + String.valueOf(illegalArgumentException)));
                        }
                    }
                    while (!this._stop && string != null) {
                        if (logger.isDebugEnabled()) {
                            if (ConsolePlugin.this.coloredPrompt) {
                                logger.debug((Object)("\u001b[33m=>\u001b[0m\"" + string + "\""));
                            } else {
                                logger.debug((Object)("=>\"" + string + "\""));
                            }
                        }
                        printWriter.flush();
                        try {
                            String[] stringArray;
                            Map map = PluginManager.getInstance().getCLCommands();
                            for (String string2 : stringArray = string.split("---")) {
                                String[] stringArray2 = StringUtil.splitStringWithEscape((String)(string2 = string2.trim()));
                                if (stringArray2.length == 0) continue;
                                CLCommand cLCommand = (CLCommand)map.get(stringArray2[0]);
                                if (cLCommand == null) {
                                    System.out.println("unknown command.");
                                    continue;
                                }
                                String[] stringArray3 = new String[stringArray2.length - 1];
                                for (int i = 0; i < stringArray3.length; ++i) {
                                    stringArray3[i] = stringArray2[i + 1];
                                }
                                cLCommand.execute(stringArray3, System.out);
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            logger.error((Object)("PromptThread: an exeption occurred: " + String.valueOf(runtimeException)));
                            logger.error((Object)runtimeException.getMessage(), (Throwable)runtimeException);
                        }
                        try {
                            try {
                                this.reader.getTerminal().init();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            string = this.reader.readLine();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            logger.error((Object)("Illegal agrument: " + illegalArgumentException.getMessage()));
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)(PromptThread.class.getSimpleName() + ": " + String.valueOf(illegalArgumentException)));
                        }
                    }
                    System.out.println("exiting 2");
                }
                catch (ThreadDeath threadDeath) {
                    logger.debug((Object)"Prompt thread exiting!");
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException.getMessage());
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug((Object)(PromptThread.class.getSimpleName() + ": " + String.valueOf(iOException)));
                }
            }
            ConsolePlugin.this.setBlockingState(false);
            System.out.println("exiting 3");
        }

        private String getPrompt() {
            if (ConsolePlugin.this.coloredPrompt) {
                return "\u001b[34mRenew > \u001b[0m";
            }
            return "Renew > ";
        }

        protected void setStop() {
            block2: {
                FileHistory fileHistory = (FileHistory)this.reader.getHistory();
                try {
                    fileHistory.flush();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException.getMessage());
                    if (!logger.isDebugEnabled()) break block2;
                    logger.debug((Object)(PromptThread.class.getSimpleName() + ": could not save prompt history" + String.valueOf(iOException)));
                }
            }
            this._stop = true;
            this.interrupt();
        }
    }
}

