/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.PolyLineSegmentLocator;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class ElbowHandle
extends LocatorHandle {
    private int fSegment;
    private int fLastX;
    private int fLastY;

    public ElbowHandle(LineConnection lineConnection, int n) {
        super(lineConnection, new PolyLineSegmentLocator(n));
        this.fSegment = n;
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        this.fLastX = n;
        this.fLastY = n2;
    }

    @Override
    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Point point;
        Point point2;
        LineConnection lineConnection = this.ownerConnection();
        Point point3 = lineConnection.pointAt(this.fSegment);
        Point point4 = lineConnection.pointAt(this.fSegment + 1);
        int n5 = n - this.fLastX;
        int n6 = n2 - this.fLastY;
        if (this.isVertical(point3, point4)) {
            int n7 = this.constrainX(point3.x + n5);
            point2 = new Point(n7, point3.y);
            point = new Point(n7, point4.y);
        } else {
            int n8 = this.constrainY(point3.y + n6);
            point2 = new Point(point3.x, n8);
            point = new Point(point4.x, n8);
        }
        lineConnection.setPointAt(point2, this.fSegment);
        lineConnection.setPointAt(point, this.fSegment + 1);
        this.fLastX = n;
        this.fLastY = n2;
    }

    private boolean isVertical(Point point, Point point2) {
        return point.x == point2.x;
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private int constrainX(int n) {
        LineConnection lineConnection = this.ownerConnection();
        Figure figure = lineConnection.start().owner();
        Figure figure2 = lineConnection.end().owner();
        Rectangle rectangle = figure.displayBox();
        Rectangle rectangle2 = figure2.displayBox();
        Insets insets = figure.connectionInsets();
        Insets insets2 = figure2.connectionInsets();
        int n2 = rectangle.x + insets.left;
        int n3 = rectangle.width - insets.left - insets.right - 1;
        int n4 = rectangle2.x + insets2.left;
        int n5 = rectangle2.width - insets2.left - insets2.right - 1;
        if (this.fSegment == 0) {
            n = Geom.range(n2, n2 + n3, n);
        }
        if (this.fSegment == lineConnection.pointCount() - 2) {
            n = Geom.range(n4, n4 + n5, n);
        }
        return n;
    }

    private int constrainY(int n) {
        LineConnection lineConnection = this.ownerConnection();
        Figure figure = lineConnection.start().owner();
        Figure figure2 = lineConnection.end().owner();
        Rectangle rectangle = figure.displayBox();
        Rectangle rectangle2 = figure2.displayBox();
        Insets insets = figure.connectionInsets();
        Insets insets2 = figure2.connectionInsets();
        int n2 = rectangle.y + insets.top;
        int n3 = rectangle.height - insets.top - insets.bottom - 1;
        int n4 = rectangle2.y + insets2.top;
        int n5 = rectangle2.height - insets2.top - insets2.bottom - 1;
        if (this.fSegment == 0) {
            n = Geom.range(n2, n2 + n3, n);
        }
        if (this.fSegment == lineConnection.pointCount() - 2) {
            n = Geom.range(n4, n4 + n5, n);
        }
        return n;
    }

    private LineConnection ownerConnection() {
        return (LineConnection)this.owner();
    }
}

