/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import java.util.Vector;

public class SnapshotHistory {
    private Vector<FigureSelection> history;
    private int maxSize;
    private Drawing drawing;
    private FigureSelection preparedSnapshot;

    public SnapshotHistory(Drawing drawing, int n) {
        this.maxSize = n;
        this.drawing = drawing;
        this.preparedSnapshot = null;
        this.history = new Vector(n);
    }

    public void takeSnapshot() {
        this.prepareSnapshot();
        this.commitSnapshot();
    }

    public void prepareSnapshot() {
        this.preparedSnapshot = new FigureSelection(this.drawing.figures());
    }

    public void commitSnapshot() {
        if (this.preparedSnapshot != null) {
            this.history.addElement(this.preparedSnapshot);
            this.preparedSnapshot = null;
            if (this.history.size() > this.maxSize) {
                this.history.removeElementAt(0);
            }
        }
    }

    public void restoreSnapshot() {
        if (this.history.size() > 0) {
            FigureSelection figureSelection = this.history.lastElement();
            this.history.removeElementAt(this.history.size() - 1);
            this.drawing.removeAll();
            Vector<Figure> vector = figureSelection.getData("CH.ifa.draw.Figures");
            this.drawing.addAll(vector);
            this.drawing.checkDamage();
        }
    }

    public void clear() {
        this.history.removeAllElements();
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }
}

