/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.io.importFormats.LolaImportFormat;
import de.renew.lola.LolaAnalyzer;
import de.renew.lola.LolaFileCreator;
import de.renew.lola.LolaResult;
import de.renew.lola.LolaTask;
import de.renew.lola.commands.CheckAllCommand;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class LolaGUI
extends JFrame {
    private static Logger logger = Logger.getLogger(CheckAllCommand.class);
    private String lolaPath = "";
    private JPanel _generalPanel = new JPanel();
    private JPanel _checkListPanel = new JPanel();
    private JPanel _markEdPanel = new JPanel();
    private CPNDrawing drawing;
    private JTable _markingTable;
    private JCheckBox _updateInitialMarkingCheckbox = new JCheckBox("Update initial marking", true);
    private CheckListAction checkListListener;
    private UpdatePlacesAction updateListener;
    protected JLabel livenessResult = new JLabel();
    protected JLabel deadlockFreedomResult = new JLabel();
    protected JLabel reversibilityResult = new JLabel();
    protected JLabel homeMarkingResult = new JLabel();
    protected JLabel boundednessResult = new JLabel();
    protected JLabel quasiLivenessResult = new JLabel();
    protected JLabel nameOfNet = new JLabel();
    private static final Vector<String> taskColumnNames = new Vector();
    private JTable _taskTable;
    protected String newTaskText;

    public LolaGUI() throws HeadlessException {
        taskColumnNames.add("Result");
        taskColumnNames.add("Verification Task");
        this.newTaskText = "";
        this.init();
    }

    public LolaGUI(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        taskColumnNames.add("Result");
        taskColumnNames.add("Verification Task");
        this.newTaskText = "";
        this.init();
    }

    public LolaGUI(String string) throws HeadlessException {
        super(string);
        taskColumnNames.add("Result");
        taskColumnNames.add("Verification Task");
        this.newTaskText = "";
        this.init();
    }

    public LolaGUI(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        taskColumnNames.add("Result");
        taskColumnNames.add("Verification Task");
        this.newTaskText = "";
        this.init();
    }

    public LolaGUI(String string, String string2) {
        super(string);
        taskColumnNames.add("Result");
        taskColumnNames.add("Verification Task");
        this.newTaskText = "";
        this.lolaPath = string2;
        this.init();
    }

    public void checkNow() {
        this.checkListListener.actionPerformed(null);
        this.updateListener.actionPerformed(null);
    }

    public void init() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        if (drawApplication.drawing() instanceof CPNDrawing) {
            this.drawing = (CPNDrawing)drawApplication.drawing();
            JTabbedPane jTabbedPane = new JTabbedPane();
            this._generalPanel.setVisible(true);
            this._checkListPanel.setVisible(true);
            this._markEdPanel.setVisible(true);
            this.setupMarkEdPanel();
            this.setupCheckListPanel();
            this.setupGeneralPanel();
            jTabbedPane.addTab("Checklist", this._checkListPanel);
            jTabbedPane.addTab("Marking Editor", this._markEdPanel);
            jTabbedPane.addTab("Tasks", this._generalPanel);
            this.add((Component)jTabbedPane, "Center");
            this.checkNow();
        } else {
            logger.error((Object)"[Lola GUI] Could not initialize, no open CPNDrawing.");
        }
    }

    private void setupGeneralPanel() {
        this._taskTable = new JTable(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.setupTaskTable();
        JScrollPane jScrollPane = new JScrollPane(this._taskTable);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        final JTextField jTextField = new JTextField(20);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LolaGUI.this.newTaskText = jTextField.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LolaGUI.this.newTaskText = jTextField.getText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jTextField.setToolTipText("<html>Input new verification task here and click the add button.<br>(some pointer on syntax should go here) <br><i>There is no syntax check so far.</i></html> ");
        JButton jButton = new JButton("Add task");
        jButton.setToolTipText("Add the entered task to the list");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LolaGUI.this.newTaskText != "") {
                    logger.info((Object)("[Lola GUI] Adding Task: " + LolaGUI.this.newTaskText));
                    TextFigure textFigure = new TextFigure(LolaGUI.this.newTaskText);
                    LolaTask lolaTask = new LolaTask(textFigure, LolaGUI.this.drawing);
                    if (lolaTask.isValid()) {
                        LolaGUI.this.drawing.add((Figure)textFigure);
                        Vector<Object> vector = new Vector<Object>();
                        vector.add(new LolaResult(6));
                        vector.add(lolaTask);
                        ((DefaultTableModel)LolaGUI.this._taskTable.getModel()).addRow(vector);
                    }
                } else {
                    logger.error((Object)"[Lola GUI] No text, no task to add.");
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add(jTextField);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Update Tasks");
        jButton2.setAlignmentX(0.5f);
        jButton2.setToolTipText("Parses the tasks in the current net drawing and displays them in the table.");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LolaFileCreator lolaFileCreator = new LolaFileCreator();
                Vector<LolaTask> vector = lolaFileCreator.parseTasks(LolaGUI.this.drawing);
                DefaultTableModel defaultTableModel = new DefaultTableModel();
                defaultTableModel.addColumn((Object)"task", vector);
                defaultTableModel.addColumn((Object)"result", new Vector());
                defaultTableModel.setColumnIdentifiers(taskColumnNames);
                LolaGUI.this._taskTable.setModel(defaultTableModel);
                LolaGUI.this.setupTaskTable();
            }
        });
        JButton jButton3 = new JButton("Check Tasks");
        jButton3.setAlignmentX(0.5f);
        jButton3.setToolTipText("Checks the selected tasks and displays the result.");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < LolaGUI.this._taskTable.getRowCount(); ++i) {
                    LolaTask lolaTask = (LolaTask)LolaGUI.this._taskTable.getValueAt(i, 1);
                    logger.info((Object)("[Lola TaskCheck] checking task " + lolaTask.toString()));
                    lolaTask.writeToFile();
                    LolaResult lolaResult = lolaTask.check();
                    LolaGUI.this._taskTable.setValueAt(lolaResult, i, 0);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton3);
        this._generalPanel.setLayout(new BorderLayout());
        this._generalPanel.add((Component)jScrollPane, "Center");
        this._generalPanel.add((Component)jPanel, "First");
        this._generalPanel.add((Component)jPanel2, "Last");
    }

    private void setupTaskTable() {
        LolaFileCreator lolaFileCreator = new LolaFileCreator();
        if (this.drawing == null) {
            System.out.println("DRAWING IS NULL");
        }
        Vector<LolaTask> vector = lolaFileCreator.parseTasks(this.drawing);
        Collections.sort(vector, new Comparator<LolaTask>(){

            @Override
            public int compare(LolaTask lolaTask, LolaTask lolaTask2) {
                Rectangle rectangle = lolaTask.getFigure().displayBox();
                Rectangle rectangle2 = lolaTask2.getFigure().displayBox();
                int n = rectangle.x == rectangle2.x && rectangle.y == rectangle2.y ? lolaTask.toString().compareTo(lolaTask2.toString()) : (rectangle.y > rectangle2.y || rectangle.y == rectangle2.y && rectangle.x > rectangle2.x ? 1 : -1);
                return n;
            }
        });
        Vector<LolaResult> vector2 = new Vector<LolaResult>();
        for (LolaTask lolaTask : vector) {
            vector2.add(new LolaResult(6));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(LolaGUI.class.getSimpleName() + ": " + lolaTask.getType()));
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn((Object)"result", vector2);
        defaultTableModel.addColumn((Object)"task", vector);
        defaultTableModel.setColumnIdentifiers(taskColumnNames);
        this._taskTable.setModel(defaultTableModel);
        this._taskTable.setFillsViewportHeight(true);
        this._taskTable.setRowHeight(20);
        this._taskTable.setIntercellSpacing(new Dimension(4, 4));
        this._taskTable.getColumnModel().getColumn(1).setPreferredWidth(350);
        this._taskTable.getColumnModel().getColumn(1).setMinWidth(350);
        this._taskTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer());
        this._taskTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this._taskTable.getColumnModel().getColumn(0).setMinWidth(20);
        this._taskTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                if (object instanceof LolaResult) {
                    logger.info((Object)("[Lola GUI] Rendering result column, " + String.valueOf(object) + "!"));
                    this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                    this.setText(Integer.valueOf(((LolaResult)object).getExitValue()).toString());
                    StringBuffer stringBuffer = new StringBuffer("<html>");
                    for (String string : ((LolaResult)object).getOutput()) {
                        stringBuffer.append(string + "<br>");
                    }
                    this.setToolTipText(stringBuffer.toString() + "</html>");
                    switch (((LolaResult)object).getExitValue()) {
                        case 0: {
                            this.setBackground(Color.GREEN);
                            break;
                        }
                        case 1: {
                            this.setBackground(Color.RED);
                            break;
                        }
                        case 3: {
                            this.setBackground(Color.BLACK);
                            break;
                        }
                        case 5: {
                            this.setBackground(Color.GRAY);
                            break;
                        }
                        default: {
                            this.setBackground(Color.WHITE);
                            this.setText("");
                            break;
                        }
                    }
                } else {
                    logger.error((Object)"[Lola GUI] This should use other renderer.");
                    super.setValue(object);
                }
            }
        });
    }

    private File drawReachGraph() {
        LolaAnalyzer lolaAnalyzer = new LolaAnalyzer();
        File file = LolaFileCreator.writeTemporaryLolaFile(this.drawing);
        String string = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf("."));
        String string2 = string + ".graph";
        String string3 = string + ".dot";
        String string4 = "png";
        String string5 = string + "." + string4;
        File file2 = null;
        LolaResult lolaResult = lolaAnalyzer.checkNet("lola-bounded-net", file);
        if (lolaResult.getExitValue() == 1) {
            Runtime runtime = Runtime.getRuntime();
            String[] stringArray = new String[]{this.lolaPath + "lola", file.toString(), "-m"};
            String string6 = "";
            Boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                logger.info((Object)("[Lola Graph] Calling " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " "));
                Process process = runtime.exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null) {
                    System.out.println(string6);
                }
                bufferedReader.close();
                process.waitFor();
                String[] stringArray2 = new String[]{this.lolaPath + "graph2dot", "-g", string2, "-d", string3};
                logger.info((Object)("[Lola Graph] Calling " + stringArray2[0] + " " + stringArray2[1] + " " + stringArray2[2] + " " + stringArray2[3] + " " + stringArray2[4] + " "));
                Process process2 = runtime.exec(stringArray2);
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
                BufferedReader bufferedReader3 = new BufferedReader(new InputStreamReader(process2.getErrorStream()));
                while ((string6 = bufferedReader3.readLine()) != null) {
                    logger.error((Object)("[graph2dot ERROR]" + string6));
                    bl = true;
                }
                while ((string6 = bufferedReader2.readLine()) != null) {
                    arrayList.add(string6);
                    logger.error((Object)("[graph2dot]" + string6));
                }
                int n = process2.waitFor();
                if (!bl.booleanValue() && n == 0) {
                    logger.info((Object)("[graph2dot] Call returned exit value " + n));
                    logger.info((Object)("[Lola Graph] Successfully created dot file in " + string3));
                }
                bufferedReader2.close();
                if (!bl.booleanValue()) {
                    String[] stringArray3 = new String[]{"dot", "-T" + string4, string3, "-o", string5};
                    Process process3 = runtime.exec(stringArray3);
                    BufferedReader bufferedReader4 = new BufferedReader(new InputStreamReader(process3.getInputStream()));
                    BufferedReader bufferedReader5 = new BufferedReader(new InputStreamReader(process3.getErrorStream()));
                    while ((string6 = bufferedReader5.readLine()) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("[dot ERROR]" + string6));
                        }
                        bl = true;
                    }
                    while ((string6 = bufferedReader4.readLine()) != null) {
                        arrayList.add(string6);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("[dot]" + string6));
                    }
                    int n2 = process3.waitFor();
                    file2 = new File(string5);
                    logger.info((Object)("[Lola Graph] dot returned " + n2 + " and imgFile in " + string5 + (file2.exists() ? " exists." : "don't exist")));
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(LolaGUI.class.getSimpleName() + ": "), (Throwable)iOException);
                }
                JOptionPane.showMessageDialog(null, "Cannot find dot.\nMake shure graphviz is installed and dot is available in your path.\nCurrent PATH is set to : \n" + System.getenv("PATH"), "Cannot find dot.", 0, GuiPlugin.getRenewIcon());
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            logger.error((Object)"[Lola GUI] Reachability graph not supported for unbounded nets.");
        }
        return file2;
    }

    private void setupMarkEdPanel() {
        int n = 3;
        int n2 = 1;
        this._markingTable = new JTable(n2, n);
        this._markingTable.getColumnModel().getColumn(0).setHeaderValue("Place");
        this._markingTable.getColumnModel().getColumn(1).setHeaderValue("Initial");
        this._markingTable.getColumnModel().getColumn(2).setHeaderValue("Check");
        JScrollPane jScrollPane = new JScrollPane(this._markingTable);
        this._markingTable.setFillsViewportHeight(true);
        JButton jButton = new JButton("Update places!");
        jButton.setToolTipText("Update the places from the currently active net.");
        JButton jButton2 = new JButton("Check reachability!");
        jButton2.setToolTipText("Check if the marking entered into the table can be reached from the initial marking (from the table).");
        JButton jButton3 = new JButton("Check home status!");
        jButton3.setToolTipText("Check if the marking entered into the table is a home state w.r.t. the initial marking (from the table).");
        JButton jButton4 = new JButton("Check coverability!");
        jButton4.setToolTipText("Check if the marking entered into the table is coverable w.r.t. the initial marking (from the table).");
        this._markEdPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 1));
        this._markEdPanel.add("Center", jScrollPane);
        this.updateListener = new UpdatePlacesAction();
        jButton.addActionListener(this.updateListener);
        jPanel.add(jButton);
        ReachableMarkingAction reachableMarkingAction = new ReachableMarkingAction();
        jButton2.addActionListener(reachableMarkingAction);
        jPanel.add(jButton2);
        HomeStateAction homeStateAction = new HomeStateAction();
        jButton3.addActionListener(homeStateAction);
        jPanel.add(jButton3);
        CoverabilityAction coverabilityAction = new CoverabilityAction();
        jButton4.addActionListener(coverabilityAction);
        jPanel.add(jButton4);
        this._updateInitialMarkingCheckbox.setToolTipText("If this is checked the initial marking will be updated from the net when the places are updated.");
        jPanel.add(this._updateInitialMarkingCheckbox);
        this._markEdPanel.add("East", jPanel);
    }

    private void setupCheckListPanel() {
        GridLayout gridLayout = new GridLayout(9, 2, 10, 5);
        this._checkListPanel.setLayout(gridLayout);
        JLabel jLabel = new JLabel("Currently checking: ");
        JLabel jLabel2 = new JLabel("Quasi-Liveness");
        JLabel jLabel3 = new JLabel("Liveness");
        JLabel jLabel4 = new JLabel("Deadlock freedom");
        JLabel jLabel5 = new JLabel("Reversibility");
        JLabel jLabel6 = new JLabel("Home Marking");
        JLabel jLabel7 = new JLabel("Boundedness");
        JLabel[] jLabelArray = new JLabel[]{jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7, jLabel};
        JLabel[] jLabelArray2 = new JLabel[]{this.quasiLivenessResult, this.livenessResult, this.deadlockFreedomResult, this.reversibilityResult, this.homeMarkingResult, this.boundednessResult, this.nameOfNet};
        jLabel2.setToolTipText("Is the net quasi-live (i.e. every transition non-dead in initial marking)?");
        jLabel3.setToolTipText("Is the net live (i.e. for all reachable markings there is a firing sequence, so that every transition can be enabled)?");
        jLabel4.setToolTipText("Is the net deadlock-free?");
        jLabel5.setToolTipText("Is the net reversible (is the initial marking a home state)?");
        jLabel6.setToolTipText("Is there a home marking in the net?");
        jLabel7.setToolTipText("Is the net bounded?");
        for (int i = 0; i < jLabelArray.length; ++i) {
            jLabelArray[i].setHorizontalAlignment(4);
            this._checkListPanel.add(jLabelArray[i]);
            jLabelArray2[i].setText("n.y.c");
            jLabelArray2[i].setForeground(Color.GRAY);
            this._checkListPanel.add(jLabelArray2[i]);
        }
        JButton jButton = new JButton("Check properties");
        this.checkListListener = new CheckListAction();
        jButton.addActionListener(this.checkListListener);
        JButton jButton2 = new JButton("Show PTN projection");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawApplication drawApplication = DrawPlugin.getGui();
                if (drawApplication.drawing() instanceof CPNDrawing) {
                    LolaGUI.this.drawing = (CPNDrawing)drawApplication.drawing();
                    File file = LolaFileCreator.writeTemporaryLolaFile(LolaGUI.this.drawing);
                    LolaImportFormat lolaImportFormat = new LolaImportFormat();
                    try {
                        Drawing drawing = lolaImportFormat.importFile(file.toURI().toURL());
                        drawApplication.showDrawingViewContainer(drawing);
                    }
                    catch (MalformedURLException malformedURLException) {
                        logger.error((Object)"[Lola GUI - Show PTN projection] Converting the file to a URL failed");
                        malformedURLException.printStackTrace();
                    }
                    catch (Exception exception) {
                        logger.error((Object)"[Lola GUI - Show PTN projection] Something went wrong with the import");
                        exception.printStackTrace();
                    }
                } else {
                    logger.error((Object)"[Lola GUI - Show PTN projection] Drawing must be CPNDrawing");
                }
            }
        });
        final JButton jButton3 = new JButton("Draw Reach. Graph");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawApplication drawApplication = DrawPlugin.getGui();
                if (drawApplication.drawing() instanceof CPNDrawing) {
                    LolaGUI.this.drawing = (CPNDrawing)drawApplication.drawing();
                    File file = LolaGUI.this.drawReachGraph();
                    if (file != null) {
                        try {
                            BufferedImage bufferedImage = ImageIO.read(file);
                            ImageIcon imageIcon = new ImageIcon(bufferedImage);
                            JFrame jFrame = new JFrame();
                            jFrame.add(new JScrollPane(new JLabel(imageIcon)));
                            jFrame.setSize(300, 600);
                            jFrame.setTitle(file.getName());
                            JRootPane jRootPane = jFrame.getRootPane();
                            jRootPane.putClientProperty("Window.documentFile", file);
                            Rectangle rectangle = jButton3.getTopLevelAncestor().getBounds();
                            jFrame.setLocation(rectangle.x + rectangle.width, rectangle.y);
                            jFrame.setVisible(true);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        });
        this._checkListPanel.add(jButton);
        this._checkListPanel.add(jButton3);
        this._checkListPanel.add(jButton2);
    }

    private int findCorrectRow(String string, int n) {
        int n2 = -1;
        for (int i = 0; i < this._markingTable.getRowCount(); ++i) {
            if (!string.equals(this._markingTable.getValueAt(i, n))) continue;
            n2 = i;
        }
        return n2;
    }

    public StringBuffer getTableMarking(int n, int n2) {
        String string = "";
        String string2 = "";
        switch (n2) {
            case 1: {
                string = " , ";
                string2 = " : ";
                break;
            }
            case 2: {
                string = " AND ";
                string2 = " >= ";
                break;
            }
            case 3: {
                string = " AND ";
                string2 = " = ";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 1) {
            stringBuffer.append("MARKING ");
        }
        boolean bl = true;
        for (int i = 0; i < this._markingTable.getRowCount(); ++i) {
            if (!bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(String.valueOf(this._markingTable.getValueAt(i, 0)) + string2);
            if (this._markingTable.getValueAt(i, n) != null && !this._markingTable.getValueAt(i, n).equals("")) {
                stringBuffer.append(this._markingTable.getValueAt(i, n));
            } else {
                stringBuffer.append("0");
            }
            bl = false;
        }
        return stringBuffer;
    }

    class CheckListAction
    implements ActionListener {
        CheckListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LolaGUI.this.nameOfNet.setText("...");
            LolaGUI.this.update(LolaGUI.this.getGraphics());
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                LolaGUI.this.drawing = (CPNDrawing)drawApplication.drawing();
            }
            logger.info((Object)("[Lola] performing checklist action with drawing " + LolaGUI.this.drawing.getName()));
            LolaAnalyzer lolaAnalyzer = new LolaAnalyzer(LolaGUI.this.lolaPath);
            LolaFileCreator lolaFileCreator = new LolaFileCreator();
            File file = LolaFileCreator.writeTemporaryLolaFile(LolaGUI.this.drawing);
            Map<String, Integer> map = lolaAnalyzer.checkLivenesAndQuasiLiveness((Drawing)LolaGUI.this.drawing, lolaFileCreator, file);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[Lola Checklist] Set results for Liveness and Quasi-Liveness");
            }
            this.colorResultLabel(LolaGUI.this.quasiLivenessResult, map.get("checkDead"));
            this.colorResultLabel(LolaGUI.this.livenessResult, map.get("checkLive"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[Lola Checklist] Check whether net is bounded");
            }
            LolaResult lolaResult = lolaAnalyzer.checkNet("lola-bounded-net", file);
            this.colorResultLabel(LolaGUI.this.boundednessResult, lolaResult.getExitValue(), true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[Lola Checklist] Check whether net is reversible");
            }
            LolaResult lolaResult2 = lolaAnalyzer.checkNet("lola-reversible", file);
            this.colorResultLabel(LolaGUI.this.reversibilityResult, lolaResult2.getExitValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[Lola Checklist] Check whether net deadlocks");
            }
            LolaResult lolaResult3 = lolaAnalyzer.checkNet("lola-deadlock", file);
            this.colorResultLabel(LolaGUI.this.deadlockFreedomResult, lolaResult3.getExitValue(), true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[Lola Checklist] Check whether net has home-state");
            }
            LolaResult lolaResult4 = lolaAnalyzer.checkNet("lola-home-state", file);
            this.colorResultLabel(LolaGUI.this.homeMarkingResult, lolaResult4.getExitValue());
        }

        private void colorResultLabel(JLabel jLabel, int n, boolean bl) {
            if (bl) {
                switch (n) {
                    case 0: {
                        this.colorResultLabel(jLabel, 1);
                        break;
                    }
                    case 1: {
                        this.colorResultLabel(jLabel, 0);
                        break;
                    }
                    default: {
                        this.colorResultLabel(jLabel, n);
                    }
                }
            }
        }

        public void colorResultLabel(JLabel jLabel, int n) {
            switch (n) {
                case 0: {
                    jLabel.setForeground(new Color(0, 153, 0));
                    jLabel.setText("[yes]");
                    break;
                }
                case 1: {
                    jLabel.setForeground(Color.RED);
                    jLabel.setText("[no]");
                    break;
                }
                case 5: {
                    jLabel.setForeground(Color.GRAY);
                    jLabel.setText("[n/a]");
                    break;
                }
                default: {
                    jLabel.setForeground(Color.BLACK);
                    jLabel.setText("ERROR");
                    jLabel.setToolTipText("An error occured, check the console output for more information.");
                    logger.error((Object)("[Lola CheckList] The lola call resulted in an unexpected result value: " + n));
                }
            }
            LolaGUI.this.nameOfNet.setText(LolaGUI.this.drawing.getName());
        }
    }

    class UpdatePlacesAction
    implements ActionListener {
        UpdatePlacesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LolaFileCreator lolaFileCreator = new LolaFileCreator();
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                LolaGUI.this.drawing = (CPNDrawing)drawApplication.drawing();
            }
            logger.info((Object)("[Lola] performing updatePlacesAction with drawing " + LolaGUI.this.drawing.getName()));
            FigureEnumeration figureEnumeration = LolaGUI.this.drawing.figures();
            DefaultTableModel defaultTableModel = new DefaultTableModel();
            defaultTableModel.addColumn("Place");
            defaultTableModel.addColumn("Initial");
            defaultTableModel.addColumn("Check");
            Object[] objectArray = new String[]{"", "", ""};
            while (figureEnumeration.hasMoreElements()) {
                int n;
                Figure figure = (Figure)figureEnumeration.nextElement();
                if (!(figure instanceof PlaceFigure) || figure instanceof VirtualPlaceFigure) continue;
                String string = lolaFileCreator.name((FigureWithID)figure);
                logger.info((Object)("[Lola] found place named " + string));
                objectArray[0] = string;
                if (LolaGUI.this._markingTable.getRowCount() >= defaultTableModel.getRowCount() && (n = LolaGUI.this.findCorrectRow(objectArray[0], 0)) > -1) {
                    objectArray[2] = (String)LolaGUI.this._markingTable.getValueAt(n, 2);
                    if (!LolaGUI.this._updateInitialMarkingCheckbox.isSelected()) {
                        objectArray[1] = (String)LolaGUI.this._markingTable.getValueAt(n, 1);
                    }
                }
                if (LolaGUI.this._updateInitialMarkingCheckbox.isSelected()) {
                    HashMap<String, String> hashMap = lolaFileCreator.getInitialMarking(LolaGUI.this.drawing);
                    objectArray[1] = hashMap.get(objectArray[0]);
                }
                defaultTableModel.addRow(objectArray);
                logger.info((Object)("[Lola] adding marking table column " + objectArray.toString()));
            }
            LolaGUI.this._markingTable.setModel(defaultTableModel);
        }
    }

    class ReachableMarkingAction
    implements ActionListener {
        ReachableMarkingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LolaAnalyzer lolaAnalyzer = new LolaAnalyzer(LolaGUI.this.lolaPath);
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                LolaGUI.this.drawing = (CPNDrawing)drawApplication.drawing();
            }
            logger.info((Object)("[Lola] performing updatePlacesAction with drawing " + LolaGUI.this.drawing.getName()));
            StringBuffer stringBuffer = LolaGUI.this.getTableMarking(1, 1).append(";");
            StringBuffer stringBuffer2 = new StringBuffer("ANALYSE ").append(LolaGUI.this.getTableMarking(2, 1));
            StringBuffer stringBuffer3 = new StringBuffer(LolaGUI.this.getTableMarking(2, 1));
            logger.info((Object)("[Lola] Initial marking from table " + stringBuffer.toString()));
            logger.info((Object)("[Lola] second marking from table " + stringBuffer2.toString()));
            if (!stringBuffer2.toString().equals("ANALYSE MARKING ")) {
                File file = LolaFileCreator.writeTemporaryLolaFile(LolaGUI.this.drawing, stringBuffer);
                LolaResult lolaResult = lolaAnalyzer.checkMarking(stringBuffer2, file);
                if (lolaResult.getExitValue() == 0) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\nis reachable!", "Lola Reachability", 1);
                } else if (lolaResult.getExitValue() == 1) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\n<html>is <b>not</b> reachable! </html>", "Lola Reachability", 0);
                } else if (lolaResult.getExitValue() > 1) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\nis not reachable or cannot be computed!", "Lola Reachability", 2);
                }
            } else {
                logger.info((Object)"[Lola] No secondary marking input. Cancelling reachability check!");
            }
        }
    }

    class HomeStateAction
    implements ActionListener {
        HomeStateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LolaAnalyzer lolaAnalyzer = new LolaAnalyzer(LolaGUI.this.lolaPath);
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                LolaGUI.this.drawing = (CPNDrawing)drawApplication.drawing();
            }
            logger.info((Object)("[Lola] performing updatePlacesAction with drawing " + LolaGUI.this.drawing.getName()));
            StringBuffer stringBuffer = LolaGUI.this.getTableMarking(1, 1).append(";");
            StringBuffer stringBuffer2 = new StringBuffer(LolaGUI.this.getTableMarking(2, 3));
            StringBuffer stringBuffer3 = new StringBuffer(LolaGUI.this.getTableMarking(2, 1));
            logger.info((Object)("[Lola] Initial marking from table " + stringBuffer.toString()));
            logger.info((Object)("[Lola] home marking in question from table " + stringBuffer2.toString()));
            if (!stringBuffer2.toString().equals("")) {
                File file = LolaFileCreator.writeTemporaryLolaFile(LolaGUI.this.drawing, stringBuffer);
                LolaResult lolaResult = lolaAnalyzer.checkStatePredicateLiveness(stringBuffer2.toString(), file);
                if (lolaResult.getExitValue() == 0) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\nis a home marking!", "Lola Home Marking", 1);
                } else if (lolaResult.getExitValue() == 1) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\n<html>is <b>not</b> a home marking!</html>", "Lola Home Marking", 0);
                } else if (lolaResult.getExitValue() > 1) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\nis not a home marking or cannot be computed!", "Lola Home Marking", 2);
                }
            } else {
                logger.info((Object)"[Lola] No home marking input. Cancelling reachability check!");
            }
        }
    }

    class CoverabilityAction
    implements ActionListener {
        CoverabilityAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LolaAnalyzer lolaAnalyzer = new LolaAnalyzer(LolaGUI.this.lolaPath);
            DrawApplication drawApplication = DrawPlugin.getGui();
            if (drawApplication.drawing() instanceof CPNDrawing) {
                LolaGUI.this.drawing = (CPNDrawing)drawApplication.drawing();
            }
            logger.info((Object)("[Lola] performing updatePlacesAction with drawing " + LolaGUI.this.drawing.getName()));
            StringBuffer stringBuffer = LolaGUI.this.getTableMarking(1, 1).append(";");
            StringBuffer stringBuffer2 = new StringBuffer(LolaGUI.this.getTableMarking(2, 2));
            StringBuffer stringBuffer3 = new StringBuffer(LolaGUI.this.getTableMarking(2, 1));
            logger.info((Object)("[Lola] Initial marking from table " + stringBuffer.toString()));
            logger.info((Object)("[Lola] coverability marking in question from table " + stringBuffer2.toString()));
            if (!stringBuffer2.toString().equals("")) {
                File file = LolaFileCreator.writeTemporaryLolaFile(LolaGUI.this.drawing, stringBuffer);
                LolaResult lolaResult = lolaAnalyzer.checkStatePredicateReachability(stringBuffer2.toString(), file);
                if (lolaResult.getExitValue() == 0) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\nis coverable!", "Lola Coverability", 1);
                } else if (lolaResult.getExitValue() == 1) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\n<html>is <b>not</b> coverable!</html>", "Lola Coverability", 0);
                } else if (lolaResult.getExitValue() > 1) {
                    JOptionPane.showMessageDialog(LolaGUI.this._markEdPanel, "The marking \n\n" + stringBuffer3.toString().substring(8) + "\n\nis not coverable or cannot be computed!", "Lola Coverability", 2);
                }
            } else {
                logger.info((Object)"[Lola] No coverable marking input. Cancelling reachability check!");
            }
        }
    }
}

