/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.lola.LolaAnalyzer;
import de.renew.lola.LolaFileCreator;
import de.renew.lola.LolaHelper;
import de.renew.lola.LolaResult;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CheckVerificationRequestCommand
extends Command
implements CLCommand {
    private File lolaPath;
    private LolaFileCreator creator;
    private LolaAnalyzer analyzer;
    private static Logger logger = Logger.getLogger(CheckVerificationRequestCommand.class);

    public CheckVerificationRequestCommand(String string, String string2) {
        super(string);
        this.lolaPath = new File(string2);
        this.creator = new LolaFileCreator();
        this.analyzer = new LolaAnalyzer(this.lolaPath.toString());
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        Drawing drawing = drawApplication.drawing();
        drawApplication.getUndoRedoManager().prepareUndoSnapshot(drawing);
        Vector vector = drawApplication.view().selection();
        if (!(drawing instanceof CPNDrawing)) {
            logger.error((Object)"[Lola] Drawing needs to be a CPNDrawing. Aborting.");
            return;
        }
        File file = LolaFileCreator.writeTemporaryLolaFile((CPNDrawing)drawing);
        String string = drawing.getName();
        Boolean bl = false;
        for (Figure figure : vector) {
            if (figure instanceof TextFigure) {
                LolaResult lolaResult;
                Object object;
                Object object2;
                String string2 = "";
                Object object3 = ((TextFigure)figure).getText();
                if (((TextFigure)figure).parent() != null && ((String)object3).startsWith("ASSERT")) {
                    object2 = ((TextFigure)figure).parent();
                    object = this.creator.name((FigureWithID)object2);
                    if (object2 instanceof PlaceFigure) {
                        object3 = "ANALYSE PLACE " + (String)object;
                        string2 = "Place";
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"[Lola] Found assert task.");
                        }
                    } else if (object2 instanceof TransitionFigure) {
                        object3 = "ANALYSE TRANSITION " + (String)object;
                        string2 = "Transition";
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"[Lola] Found assert task.");
                        }
                    } else {
                        string2 = "";
                        logger.error((Object)"[Lola] Assert statements need to be attached to places or transitions.");
                    }
                } else {
                    string2 = this.creator.parseTask((TextFigure)figure);
                }
                if (string2.equals("")) {
                    logger.error((Object)"[Lola] No parseable task found in text.");
                    continue;
                }
                object2 = string + string2;
                object = this.creator.writeTaskFile((String)object2, (String)object3, string2);
                String string3 = LolaHelper.taskCommandMap.get(string2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[Lola] Checking task of type " + string2 + " from file " + ((File)object).toString() + "."));
                }
                if ((lolaResult = this.analyzer.checkTask((File)object, file, string3)).getExitValue() == 3) {
                    figure.setAttribute("FrameColor", (Object)Color.BLACK);
                    logger.error((Object)("[Lola] Syntax Error, correct verification request." + lolaResult.toString()));
                    logger.info((Object)("[Lola]\n" + this.formatMessage(lolaResult.getOutput())));
                } else if (lolaResult.getExitValue() == 5) {
                    figure.setAttribute("FrameColor", (Object)Color.GRAY);
                    logger.error((Object)"[Lola] Verification couldn't be verified. Maximal number of states reached.");
                } else if (lolaResult.getExitValue() == 0) {
                    figure.setAttribute("FrameColor", (Object)(string2.equals("Place") ? Color.RED : Color.GREEN));
                    logger.info((Object)("[Lola] " + lolaResult.getResult().toString()));
                } else if (lolaResult.getExitValue() == 1) {
                    figure.setAttribute("FrameColor", (Object)(string2.equals("Place") ? Color.GREEN : Color.RED));
                    logger.info((Object)("[Lola] " + lolaResult.getResult().toString()));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("[Lola] " + lolaResult.getOutput().toString()));
                    }
                }
                figure.changed();
                bl = true;
                continue;
            }
            logger.info((Object)"[Lola] Currently only checking TextFigures.");
        }
        if (bl.booleanValue()) {
            DrawPlugin.getGui().view().checkDamage();
            drawApplication.getUndoRedoManager().commitUndoSnapshot(drawing);
        }
    }

    private String formatMessage(ArrayList<String> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList) {
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return null;
    }
}

