/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.lola.LolaAnalyzer;
import de.renew.lola.LolaFileCreator;
import de.renew.lola.LolaHelper;
import de.renew.lola.LolaResult;
import java.awt.Color;
import java.io.File;
import org.apache.log4j.Logger;

public class LolaTask {
    private static Logger logger = Logger.getLogger(LolaTask.class);
    private String _text;
    private String _type;
    private final TextFigure _figure;
    private final CPNDrawing _drawing;
    private LolaResult _result;
    private File _file;
    private boolean _valid;

    public LolaTask(TextFigure textFigure, CPNDrawing cPNDrawing) {
        this._figure = textFigure;
        this._drawing = cPNDrawing;
        this._text = textFigure.getText();
        this._type = this.parseText(this._text);
        this._valid = !this._type.equals("");
    }

    private String parseText(String string) {
        logger.info((Object)("[Lola Task] Parsing verification task " + this.toString()));
        String string2 = "";
        if (this._figure.parent() != null && string.startsWith("ASSERT")) {
            LolaFileCreator lolaFileCreator = new LolaFileCreator();
            ParentFigure parentFigure = this._figure.parent();
            String string3 = lolaFileCreator.name((FigureWithID)parentFigure);
            if (parentFigure instanceof PlaceFigure) {
                this._text = "ANALYSE PLACE " + string3;
                string2 = "Place";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"[Lola] Found assert task.");
                }
            } else if (parentFigure instanceof TransitionFigure) {
                this._text = "ANALYSE TRANSITION " + string3;
                string2 = "Transition";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"[Lola] Found assert task.");
                }
            } else {
                this._type = "";
                logger.error((Object)"[Lola] Assert statements need to be attached to places or transitions.");
            }
        } else if (this._figure.parent() == null) {
            if (string.startsWith("ANALYSE MARKING")) {
                string2 = "Marking";
            } else if (string.startsWith("ANALYSE TRANSITION")) {
                string2 = "Transition";
            } else if (string.startsWith("ANALYSE PLACE")) {
                string2 = "Place";
            } else if (string.startsWith("FORMULA")) {
                string2 = LolaHelper.ctlp(string).booleanValue() ? "CTL" : "StatePredicate";
            } else {
                logger.error((Object)"[Lola] Didn't recognize the type of the task.");
            }
        }
        return string2;
    }

    public LolaResult check() {
        if (this._type.equals("")) {
            logger.error((Object)"[Lola] Not a valid task type, can't check.");
            return null;
        }
        LolaResult lolaResult = null;
        LolaAnalyzer lolaAnalyzer = new LolaAnalyzer();
        File file = LolaFileCreator.writeTemporaryLolaFile(this._drawing);
        if (this._file == null) {
            logger.info((Object)("[Lola Task] Writing" + this.toString() + " into file."));
            this._file = this.writeToFile();
        }
        if (this._file != null && this._file.exists()) {
            String string = LolaHelper.taskCommandMap.get(this._type);
            lolaResult = this._result = lolaAnalyzer.checkTask(this._file, file, string);
        } else {
            logger.error((Object)"[Lola Task] No taskfile to check.");
        }
        return lolaResult;
    }

    public File writeToFile() {
        File file = null;
        LolaFileCreator lolaFileCreator = new LolaFileCreator();
        file = lolaFileCreator.writeTaskFile(this._drawing.getName(), this._text, this._type);
        if (file.exists()) {
            this._file = file;
        }
        return file;
    }

    public void colorFigure() {
        if (this._result != null) {
            if (this._result.getExitValue() == 3) {
                this._figure.setAttribute("FrameColor", (Object)Color.BLACK);
                logger.error((Object)"[Lola] Syntax Error, correct verification request.");
            } else if (this._result.getExitValue() == 5) {
                this._figure.setAttribute("FrameColor", (Object)Color.GRAY);
                logger.error((Object)"[Lola] Verification couldn't be verified. Maximal number of stated reached.");
            } else if (this._result.getExitValue() == 0) {
                this._figure.setAttribute("FrameColor", (Object)(this._type.equals("Place") ? Color.RED : Color.GREEN));
            } else if (this._result.getExitValue() == 1) {
                this._figure.setAttribute("FrameColor", (Object)(this._type.equals("Place") ? Color.GREEN : Color.RED));
            }
            this._figure.changed();
            DrawPlugin.getGui().view().checkDamage();
        } else {
            logger.error((Object)"[Lola Task] Task seems to be not yet checked.");
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public String toString() {
        return this._text;
    }

    public String getType() {
        return this._type;
    }

    public TextFigure getFigure() {
        return this._figure;
    }
}

