/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.analysis;

import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.parser.LolaParser;
import de.renew.lola2.parser.NetFileParseError;
import de.renew.lola2.parser.Place;
import de.renew.lola2.parser.Transition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class PropertyAnalyzer
extends LolaAnalyzer {
    private static Logger logger = Logger.getLogger(PropertyAnalyzer.class);

    public PropertyAnalyzer(String string) {
        super(string);
    }

    public PropertyAnalyzer() {
    }

    public DirectLolaResult checkTransitionQuasiLiveness(String string, File file) {
        String string2 = "EF FIREABLE(" + string + ")";
        logger.debug((Object)("[LolaAnalyzer] Checking quasi-liveness for transition named " + string));
        DirectLolaResult directLolaResult = this.callLola(string2, file);
        return directLolaResult;
    }

    public DirectLolaResult checkTransitionLiveness(String string, File file) {
        logger.debug((Object)("[LolaAnalyzer] Checking liveness for transition named " + string));
        String string2 = "AG EF FIREABLE(" + string + ")";
        DirectLolaResult directLolaResult = this.callLola(string2, file);
        return directLolaResult;
    }

    public DirectLolaResult checkPlaceBoundedness(String string, File file) {
        String string2 = "AG " + string + " < oo";
        logger.debug((Object)("[LolaAnalyzer] Checking boundedness for place named " + string));
        DirectLolaResult directLolaResult = this.callLola(string2, file, new String[]{"--search=cover", "--encoder=full"});
        return directLolaResult;
    }

    public IndirectLolaResult checkNetBoundedness(File file) {
        LolaParser lolaParser;
        Object object;
        try {
            object = new FileInputStream(file);
            try {
                lolaParser = new LolaParser();
                lolaParser.parse((InputStream)object);
            }
            finally {
                object.close();
            }
        }
        catch (NetFileParseError | IOException exception) {
            logger.error((Object)("[LolaAnalyzer] Could not parse netFile " + file.getAbsolutePath()));
            return new IndirectLolaResult(LolaResultStatus.ERROR);
        }
        object = LolaResultStatus.YES;
        for (Place place : lolaParser.getPlaces()) {
            String string = place.getName();
            DirectLolaResult directLolaResult = this.checkPlaceBoundedness(string, file);
            LolaResultStatus lolaResultStatus = directLolaResult.getStatus();
            if (lolaResultStatus == LolaResultStatus.YES) continue;
            if (lolaResultStatus == LolaResultStatus.NO) {
                object = lolaResultStatus;
                logger.info((Object)("[Lola Checklist] Found unbounded place " + string + ". Net is not bounded. "));
                break;
            }
            object = lolaResultStatus;
            logger.info((Object)("[Lola Checklist] Could not check boundedness for " + string + ". Status: " + String.valueOf((Object)lolaResultStatus)));
            break;
        }
        return new IndirectLolaResult((LolaResultStatus)((Object)object));
    }

    public IndirectLolaResult checkNetLiveness(File file, boolean bl) {
        LolaResultStatus lolaResultStatus;
        DirectLolaResult directLolaResult;
        String string;
        LolaParser lolaParser;
        Object object;
        try {
            object = new FileInputStream(file);
            try {
                lolaParser = new LolaParser();
                lolaParser.parse((InputStream)object);
            }
            finally {
                object.close();
            }
        }
        catch (NetFileParseError | IOException exception) {
            logger.error((Object)("[LolaAnalyzer] Could not parse netFile " + file.getAbsolutePath()));
            return new IndirectLolaResult(LolaResultStatus.ERROR);
        }
        object = LolaResultStatus.YES;
        if (bl) {
            for (Transition transition : lolaParser.getTransitions()) {
                string = transition.getName();
                directLolaResult = this.checkTransitionQuasiLiveness(string, file);
                lolaResultStatus = directLolaResult.getStatus();
                if (lolaResultStatus == LolaResultStatus.YES) continue;
                if (lolaResultStatus == LolaResultStatus.NO) {
                    object = lolaResultStatus;
                    logger.info((Object)("[Lola Checklist] Found dead transition " + string + ". Net is not live. "));
                    break;
                }
                object = lolaResultStatus;
                logger.info((Object)("[Lola Checklist] Could not check quasi-liveness for " + string + ". Status: " + String.valueOf((Object)lolaResultStatus)));
                break;
            }
        }
        if (object == LolaResultStatus.YES) {
            for (Transition transition : lolaParser.getTransitions()) {
                string = transition.getName();
                directLolaResult = this.checkTransitionLiveness(string, file);
                lolaResultStatus = directLolaResult.getStatus();
                if (lolaResultStatus == LolaResultStatus.YES) continue;
                if (lolaResultStatus == LolaResultStatus.NO) {
                    object = lolaResultStatus;
                    logger.info((Object)("[Lola Checklist] Found not-live transition " + string + ". Net is not live. "));
                    break;
                }
                object = lolaResultStatus;
                logger.info((Object)("[Lola Checklist] Could not check liveness for " + string + ". Status: " + String.valueOf((Object)lolaResultStatus)));
                break;
            }
        }
        return new IndirectLolaResult((LolaResultStatus)((Object)object));
    }

    public IndirectLolaResult checkNetQuasiLiveness(File file) {
        LolaParser lolaParser;
        Object object;
        try {
            object = new FileInputStream(file);
            try {
                lolaParser = new LolaParser();
                lolaParser.parse((InputStream)object);
            }
            finally {
                object.close();
            }
        }
        catch (NetFileParseError | IOException exception) {
            logger.error((Object)("[LolaAnalyzer] Could not parse netFile " + file.getAbsolutePath()));
            return new IndirectLolaResult(LolaResultStatus.ERROR);
        }
        object = LolaResultStatus.YES;
        for (Transition transition : lolaParser.getTransitions()) {
            String string = transition.getName();
            DirectLolaResult directLolaResult = this.checkTransitionQuasiLiveness(string, file);
            LolaResultStatus lolaResultStatus = directLolaResult.getStatus();
            if (lolaResultStatus == LolaResultStatus.YES) continue;
            if (lolaResultStatus == LolaResultStatus.NO) {
                object = lolaResultStatus;
                logger.info((Object)("[Lola Checklist] Found dead transition " + string + ". Net is not quasi-live. "));
                break;
            }
            object = lolaResultStatus;
            logger.info((Object)("[Lola Checklist] Could not check quasi-liveness for " + string + ". Status: " + String.valueOf((Object)lolaResultStatus)));
            break;
        }
        return new IndirectLolaResult((LolaResultStatus)((Object)object));
    }

    public DirectLolaResult checkNetDeadlockFreedom(File file) {
        String string = "NOT EF DEADLOCK";
        logger.debug((Object)"[LolaAnalyzer] Checking deadlock freedom");
        DirectLolaResult directLolaResult = this.callLola(string, file);
        return directLolaResult;
    }

    public DirectLolaResult checkMarkingReachability(String string, File file) {
        String string2 = "EF " + string;
        logger.debug((Object)("[LolaAnalyzer] Checking reachability of marking " + string));
        DirectLolaResult directLolaResult = this.callLola(string2, file);
        return directLolaResult;
    }

    public DirectLolaResult checkMarkingHomeState(String string, File file) {
        String string2 = "AG EF " + string;
        logger.debug((Object)("[LolaAnalyzer] Checking wether " + string + " is a home state"));
        DirectLolaResult directLolaResult = this.callLola(string2, file);
        return directLolaResult;
    }

    public DirectLolaResult checkNetReversibility(File file) {
        return this.checkMarkingHomeState("INITIAL", file);
    }
}

