/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class CheckAllCommand
extends Command
implements CLCommand {
    private String lolaPath;
    private static Logger logger = Logger.getLogger(CheckAllCommand.class);

    public CheckAllCommand(String string, String string2) {
        super(string);
        this.lolaPath = string2;
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        CPNDrawing cPNDrawing = (CPNDrawing)drawApplication.drawing();
        drawApplication.getUndoRedoManager().prepareUndoSnapshot(drawApplication.drawing());
        PropertyAnalyzer propertyAnalyzer = new PropertyAnalyzer(this.lolaPath);
        LolaFileCreator lolaFileCreator = new LolaFileCreator();
        File file = lolaFileCreator.writeTemporaryLolaFile(cPNDrawing);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + file.getPath()));
        }
        FigureEnumeration figureEnumeration = cPNDrawing.figures();
        boolean bl = false;
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            LolaResult lolaResult = null;
            if (figure instanceof PlaceFigure) {
                if (figure instanceof VirtualPlaceFigure) continue;
                var10_10 = lolaFileCreator.getNameForFigure(figure);
                lolaResult = propertyAnalyzer.checkPlaceBoundedness(var10_10, file);
            } else if (figure instanceof TransitionFigure) {
                var10_10 = lolaFileCreator.getNameForFigure(figure);
                lolaResult = propertyAnalyzer.checkTransitionLiveness(var10_10, file);
            }
            if (lolaResult == null) continue;
            switch (lolaResult.getStatus()) {
                case YES: {
                    LolaGUIHelper.colorFigure(figure, Color.GREEN);
                    break;
                }
                case NO: {
                    LolaGUIHelper.colorFigure(figure, Color.RED);
                    break;
                }
            }
            bl = true;
        }
        if (bl) {
            DrawPlugin.getGui().view().checkDamage();
            drawApplication.getUndoRedoManager().commitUndoSnapshot((Drawing)cPNDrawing);
        }
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return "Check all places and transitions.";
    }
}

