/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import de.renew.refactoring.match.DownlinkMatch;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.match.UplinkMatch;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.renamechannel.NoLinkSelectedException;
import de.renew.refactoring.renamechannel.RenameChannelRefactoring;
import de.renew.refactoring.search.range.DrawingSearchRange;
import de.renew.refactoring.search.range.SearchRange;
import de.renew.refactoring.search.range.SearchRanges;
import de.renew.refactoring.wizard.ComboBoxPanel;
import de.renew.refactoring.wizard.DrawingListPanel;
import de.renew.refactoring.wizard.ProgressBarWizardPage;
import de.renew.refactoring.wizard.SearchRangeSelectPanel;
import de.renew.refactoring.wizard.SelectMatchesTable;
import de.renew.refactoring.wizard.TableSelectButton;
import de.renew.refactoring.wizard.TextFieldPanel;
import de.renew.refactoring.wizard.WizardController;
import de.renew.refactoring.wizard.WizardPage;
import de.renew.refactoring.wizard.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class RenameChannelWizardController
extends WizardController {
    private static Logger logger = Logger.getLogger(RenameChannelWizardController.class);
    private State _state = State.STARTED;
    private final RenameChannelRefactoring _refactoring;
    private final Map<SearchRange, List<LinkMatch>> _matches;
    static final String SELECT_LINK_PAGE = "SELECT_LINK_PAGE";
    static final String ENTER_NEW_CHANNEL_NAME_PAGE = "ENTER_NEW_CHANNEL_NAME_PAGE";
    static final String SELECT_MATCHES_PAGE = "SELECT_MATCHES_PAGE";
    static final String FINISH_PAGE = "FINISH_PAGE";
    static final int CHECKBOX_COLUMN = 0;
    static final int NET_NAME_COLUMN = 1;
    static final int CONTEXT_COLUMN = 2;
    static final int LINKMATCH_OBJECT_COLUMN = 3;
    static final int NUMBER_OF_COLUMNS = 4;

    public RenameChannelWizardController(LinkParser linkParser, Drawing drawing, List<Figure> list) throws NoLinkSelectedException {
        this._refactoring = new RenameChannelRefactoring(linkParser, drawing, list);
        this._matches = new HashMap<SearchRange, List<LinkMatch>>();
    }

    @Override
    public String getTitle() {
        return "Rename Channel";
    }

    @Override
    public WizardPage getNextPage() {
        Object object;
        if (this._state == State.STARTED) {
            object = this._refactoring.getSelectedLinks();
            if (object.size() > 1) {
                return this.makeSelectLinkPage((List<LinkMatch>)object);
            }
            this._refactoring.setSelectedLink(object.get(0));
            this._state = State.SELECTED_LINK;
        }
        if (this._state == State.SELECTED_LINK) {
            return this.makeEnterNewChannelNamePage(this._refactoring.getOldChannelName(), this._refactoring.getParameterCount());
        }
        if (this._state == State.ENTERED_NEW_CHANNEL_NAME) {
            object = this.makeSelectMatchesPage();
            SwingWorker<List<LinkMatch>, Void> swingWorker = this.makeSearchWorker((ProgressBarWizardPage<List<LinkMatch>>)object);
            swingWorker.execute();
            return object;
        }
        if (this._state == State.SELECTED_MATCHES) {
            object = this.makeFinishPage();
            SwingWorker<List<Drawing>, Void> swingWorker = this.makeEditWorker((ProgressBarWizardPage<List<Drawing>>)object);
            swingWorker.execute();
            return object;
        }
        return null;
    }

    private SwingWorker<List<LinkMatch>, Void> makeSearchWorker(final ProgressBarWizardPage<List<LinkMatch>> progressBarWizardPage) {
        return new SwingWorker<List<LinkMatch>, Void>(){

            @Override
            protected List<LinkMatch> doInBackground() throws Exception {
                DrawingSearchRange drawingSearchRange = RenameChannelWizardController.this._refactoring.getSearchRange();
                if (RenameChannelWizardController.this._matches.containsKey(drawingSearchRange)) {
                    return RenameChannelWizardController.this._matches.get(drawingSearchRange);
                }
                ArrayList<LinkMatch> arrayList = new ArrayList<LinkMatch>();
                while (RenameChannelWizardController.this._refactoring.hasNextDrawingToSearch()) {
                    arrayList.addAll(RenameChannelWizardController.this._refactoring.findLinksInNextDrawing());
                    progressBarWizardPage.setProgress(RenameChannelWizardController.this._refactoring.getReferencingLinkFinderProgress());
                    progressBarWizardPage.setStatus("<html>Searching drawing: <i>" + RenameChannelWizardController.this._refactoring.getCurrentlySearchedDrawingName() + "</i></html>");
                }
                RenameChannelWizardController.this._matches.put(drawingSearchRange, arrayList);
                return arrayList;
            }

            @Override
            protected void done() {
                try {
                    progressBarWizardPage.done((List)this.get());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private SwingWorker<List<Drawing>, Void> makeEditWorker(final ProgressBarWizardPage<List<Drawing>> progressBarWizardPage) {
        return new SwingWorker<List<Drawing>, Void>(){

            @Override
            protected List<Drawing> doInBackground() throws Exception {
                while (RenameChannelWizardController.this._refactoring.hasNextEdit()) {
                    RenameChannelWizardController.this._refactoring.performNextEdit();
                    progressBarWizardPage.setProgress(RenameChannelWizardController.this._refactoring.getEditorProgress());
                    progressBarWizardPage.setStatus("<html>Editing file: <i>" + RenameChannelWizardController.this._refactoring.getCurrentlyEditedDrawingName() + "</i></html>");
                }
                return RenameChannelWizardController.this._refactoring.getChangedDrawings();
            }

            @Override
            protected void done() {
                try {
                    progressBarWizardPage.done((List)this.get());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    private WizardPage makeSelectLinkPage(final List<LinkMatch> list) {
        return new WizardPage(SELECT_LINK_PAGE){
            ComboBoxPanel<LinkMatch> _comboBox;

            @Override
            protected void didLoad() {
                this._comboBox = new ComboBoxPanel("Select the link to rename:", list);
                this.getPanel().add(this._comboBox);
            }

            @Override
            protected void didAppear() {
                this._comboBox.focus();
                RenameChannelWizardController.this.setNextButtonEnabled(true);
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.setSelectedLink(this._comboBox.getInput());
                RenameChannelWizardController.this._state = State.SELECTED_LINK;
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.setSelectedLink(null);
                RenameChannelWizardController.this._state = State.STARTED;
            }
        };
    }

    private WizardPage makeEnterNewChannelNamePage(final String string, int n) {
        String string2 = "parameter" + (n != 1 ? "s" : "");
        final String string3 = "<html>Enter the new name for <i>" + string + "</i> (" + n + " " + string2 + "):</html>";
        return new WizardPage(ENTER_NEW_CHANNEL_NAME_PAGE){
            TextFieldPanel _textField;
            SearchRangeSelectPanel _searchRange;

            @Override
            protected void didLoad() {
                this._textField = new TextFieldPanel(string3, string){
                    private static final long serialVersionUID = 5496760266040789662L;

                    @Override
                    public void inputChanged(String string) {
                        this.configureNextButton(string);
                    }
                };
                this.getPanel().add(this._textField);
                ArrayList<SearchRange> arrayList = new ArrayList<SearchRange>(SearchRanges.netDrawingSearchRanges(RenameChannelWizardController.this._refactoring.getInitialDrawing()));
                this._searchRange = new SearchRangeSelectPanel(arrayList);
                this.getPanel().add(this._searchRange);
            }

            @Override
            protected void didAppear() {
                this._textField.focus();
                this.configureNextButton(this._textField.getInput());
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.setSearchRange((DrawingSearchRange)this._searchRange.getValue());
                RenameChannelWizardController.this._refactoring.setNewChannelName(this._textField.getInput());
                RenameChannelWizardController.this._state = State.ENTERED_NEW_CHANNEL_NAME;
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.setSearchRange(null);
                RenameChannelWizardController.this._refactoring.setNewChannelName(null);
                RenameChannelWizardController.this._state = State.STARTED;
            }

            private void configureNextButton(String string2) {
                RenameChannelWizardController.this.setNextButtonEnabled(RenameChannelWizardController.this._refactoring.isValidChannelName(string2));
            }
        };
    }

    private ProgressBarWizardPage<List<LinkMatch>> makeSelectMatchesPage() {
        return new ProgressBarWizardPage<List<LinkMatch>>(SELECT_MATCHES_PAGE){
            List<LinkMatch> _matches;
            SelectMatchesTable<LinkMatch> _table;

            @Override
            protected void didAppear() {
                RenameChannelWizardController.this.setNextButtonEnabled(!this.isInProgress());
            }

            @Override
            protected String nextButtonTitle() {
                return "Preview";
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.setLinksToReplace(this._table.getSelectedItems());
                RenameChannelWizardController.this._state = State.SELECTED_MATCHES;
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.setLinksToReplace(null);
                RenameChannelWizardController.this._state = State.ENTERED_NEW_CHANNEL_NAME;
            }

            @Override
            protected void progressDone(List<LinkMatch> list) {
                RenameChannelWizardController.this.setNextButtonEnabled(true);
                JPanel jPanel = this.getPanel();
                jPanel.setLayout(new BorderLayout(0, 10));
                JLabel jLabel = new JLabel("Select the links to be replaced:");
                jPanel.add((Component)jLabel, "North");
                this._matches = list;
                LinkMatch linkMatch = RenameChannelWizardController.this._refactoring.getSelectedLink();
                Object[][] objectArray = this.makeRowData(this._matches, linkMatch);
                String[] stringArray = new String[]{"refactor", "drawing", "context", ""};
                int[] nArray = new int[]{0};
                this._table = new SelectMatchesTable<LinkMatch>(LinkMatch.class, objectArray, stringArray, nArray);
                jPanel.add((Component)new JScrollPane(this._table), "Center");
                JPanel jPanel2 = this.makeSelectButtonsPanel(this._table);
                jPanel.add((Component)jPanel2, "South");
                jPanel.revalidate();
                RenameChannelWizardController.this.focusNextButton();
            }

            private Object[][] makeRowData(List<LinkMatch> list, LinkMatch linkMatch) {
                Object[][] objectArray = new Object[list.size()][4];
                logger.debug((Object)("Matches size: " + list.size()));
                boolean bl = false;
                for (int i = 0; i < list.size(); ++i) {
                    LinkMatch linkMatch2 = list.get(i);
                    if (linkMatch2.equals(linkMatch)) {
                        var7_7 = 0;
                        bl = true;
                    } else {
                        var7_7 = bl ? i : i + 1;
                    }
                    objectArray[var7_7] = new Object[4];
                    objectArray[var7_7][0] = Boolean.TRUE;
                    objectArray[var7_7][1] = linkMatch2.getDrawing().getName();
                    objectArray[var7_7][2] = linkMatch2.matchWithContext();
                    objectArray[var7_7][3] = linkMatch2;
                }
                return objectArray;
            }

            private JPanel makeSelectButtonsPanel(JTable jTable) {
                JPanel jPanel = new JPanel(new WrapLayout());
                jPanel.add(new JLabel("Select:"));
                jPanel.add(TableSelectButton.selectAllButton("All", jTable, 0));
                jPanel.add(TableSelectButton.selectNoneButton("None", jTable, 0));
                TableSelectButton tableSelectButton = TableSelectButton.selectInstancesButton("Uplinks", UplinkMatch.class, jTable, 0, 3);
                jPanel.add(tableSelectButton);
                TableSelectButton tableSelectButton2 = TableSelectButton.selectInstancesButton("Downlinks", DownlinkMatch.class, jTable, 0, 3);
                jPanel.add(tableSelectButton2);
                return jPanel;
            }
        };
    }

    private ProgressBarWizardPage<List<Drawing>> makeFinishPage() {
        return new ProgressBarWizardPage<List<Drawing>>(FINISH_PAGE){

            @Override
            protected void didAppear() {
                RenameChannelWizardController.this.setNextButtonEnabled(!this.isInProgress());
            }

            @Override
            protected boolean isLastPage() {
                return true;
            }

            @Override
            protected void saveState() {
                RenameChannelWizardController.this._refactoring.saveChangedDrawings();
            }

            @Override
            protected void resetState() {
                RenameChannelWizardController.this._refactoring.restorePreviousTexts();
            }

            @Override
            protected void progressDone(List<Drawing> list) {
                RenameChannelWizardController.this._state = State.FINISHED;
                RenameChannelWizardController.this.setNextButtonEnabled(true);
                JPanel jPanel = this.getPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)new DrawingListPanel(list, "Finished. The following drawings will be saved:"), "Center");
            }
        };
    }

    private static enum State {
        STARTED,
        SELECTED_LINK,
        ENTERED_NEW_CHANNEL_NAME,
        SELECTED_MATCHES,
        FINISHED;

    }
}

