/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.util;

public final class ProgressCalculator {
    private ProgressCalculator() {
    }

    public static int calculateProgress(int n, int n2) {
        if (n2 == 0) {
            return 100;
        }
        return ProgressCalculator.sanitizeProgress(100.0 * (double)n / (double)n2);
    }

    public static int combinedProgress(int n, int n2, int n3, int n4) {
        if (n2 + n4 == 0) {
            return 100;
        }
        return ProgressCalculator.sanitizeProgress((n2 * n + n4 * n3) / (n2 + n4));
    }

    private static int sanitizeProgress(double d) {
        return ProgressCalculator.sanitizeProgress((int)Math.round(d));
    }

    private static int sanitizeProgress(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 100) {
            return 100;
        }
        return n;
    }
}

