/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.net.MultisetPlaceInstance;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceImpl;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.unify.Impossible;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResettableNetInstance
extends NetInstanceImpl {
    static final int HASH_CODE_MAX_DEPTH = 4;
    String originalID;

    public ResettableNetInstance(Net net, boolean bl) throws Impossible {
        super(net, bl);
        this.originalID = super.getID();
    }

    public ResettableNetInstance(NetInstance netInstance) throws Impossible {
        this(netInstance, null);
    }

    public ResettableNetInstance(NetInstance netInstance, Map<NetInstance, ResettableNetInstance> map) throws Impossible {
        super(netInstance.getNet(), false);
        this.setOriginalID(netInstance);
        this.setTo(netInstance, map);
    }

    private void setOriginalID(NetInstance netInstance) {
        this.originalID = netInstance instanceof ResettableNetInstance ? ((ResettableNetInstance)netInstance).originalID : netInstance.getID();
    }

    public String getID() {
        return this.originalID + "," + super.getID();
    }

    public String toString() {
        return String.valueOf(this.getNet()) + "[" + this.originalID + "]";
    }

    public ResettableNetInstance copy() {
        return this.copy(null, null);
    }

    public ResettableNetInstance copy(Map<NetInstance, ResettableNetInstance> map, Collection<NetInstance> collection) {
        try {
            return new ResettableNetInstance((NetInstance)this, map);
        }
        catch (Impossible impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public Collection<NetInstance> setTo(NetInstance netInstance) {
        return this.setTo(netInstance, null);
    }

    public Set<NetInstance> setTo(NetInstance netInstance, Map<NetInstance, ResettableNetInstance> map) {
        assert (this.getNet() == netInstance.getNet());
        if (netInstance == this) {
            return null;
        }
        HashSet<NetInstance> hashSet = new HashSet<NetInstance>();
        this.setOriginalID(netInstance);
        for (Place place : this.getNet().places) {
            MultisetPlaceInstance multisetPlaceInstance = (MultisetPlaceInstance)this.getInstance(place);
            PlaceInstance placeInstance = netInstance.getInstance(place);
            multisetPlaceInstance.extractAllTokens(null, null);
            Set set = placeInstance.getDistinctTestableTokens();
            for (Object object : set) {
                int n = placeInstance.getTokenCount(object);
                if (object == netInstance) {
                    object = this;
                } else if (object instanceof NetInstance && map != null) {
                    NetInstance netInstance2 = (NetInstance)object;
                    hashSet.add(netInstance2);
                    ResettableNetInstance resettableNetInstance = map.get(netInstance2);
                    if (resettableNetInstance == null) {
                        try {
                            resettableNetInstance = new ResettableNetInstance(netInstance2);
                        }
                        catch (Impossible impossible) {
                            throw new RuntimeException(impossible);
                        }
                        map.put(netInstance2, resettableNetInstance);
                    }
                    object = resettableNetInstance;
                }
                multisetPlaceInstance.internallyInsertTokenMultiple(object, 0.0, n, false);
            }
        }
        return hashSet;
    }

    public int stateHashCode() {
        return this.stateHashCode(4);
    }

    private int stateHashCode(int n) {
        int n2 = 0;
        for (Place place : this.getNet().places) {
            n2 += this.getPlaceHash(place, n);
        }
        return n2;
    }

    private int getPlaceHash(Place place, int n) {
        int n2 = 0;
        PlaceInstance placeInstance = this.getInstance(place);
        for (Object e : placeInstance.getDistinctTokens()) {
            int n3;
            if (!(e instanceof NetInstance)) {
                n3 = e.hashCode();
            } else if (e == this) {
                n3 = -42;
            } else if (n > 0) {
                if (!(e instanceof ResettableNetInstance)) {
                    throw new ClassCastException(String.valueOf(e) + " should have been a " + ResettableNetInstance.class.getName() + " object");
                }
                n3 = ((ResettableNetInstance)((Object)e)).stateHashCode(n - 1);
            } else {
                n3 = 0;
            }
            n2 += n3 ^ placeInstance.getTokenCount(e);
        }
        return n2 ^ place.hashCode();
    }

    public boolean stateEquals(Object object, Map<ResettableNetInstance, ResettableNetInstance> map) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NetInstance)) {
            return false;
        }
        if (!(object instanceof ResettableNetInstance)) {
            throw new RuntimeException("A " + ResettableNetInstance.class.getSimpleName() + " object was compared with a " + NetInstance.class.getSimpleName() + " object that is not a " + ResettableNetInstance.class.getSimpleName() + ".");
        }
        ResettableNetInstance resettableNetInstance = (ResettableNetInstance)((Object)object);
        if (this.getNet() != resettableNetInstance.getNet()) {
            return false;
        }
        Set set = this.getNet().places;
        for (Place place : set) {
            if (this.placesNormalTokensEqual((NetInstance)resettableNetInstance, place)) continue;
            return false;
        }
        map.put(this, resettableNetInstance);
        if (!this.containedNetInstanceTokensEqual((NetInstance)resettableNetInstance, set, map)) {
            map.remove((Object)this);
            return false;
        }
        return true;
    }

    private boolean placesNormalTokensEqual(NetInstance netInstance, Place place) {
        PlaceInstance placeInstance = this.getInstance(place);
        PlaceInstance placeInstance2 = netInstance.getInstance(place);
        Set set = placeInstance.getDistinctTokens();
        Set set2 = placeInstance2.getDistinctTokens();
        if (set.size() != set2.size()) {
            return false;
        }
        for (Object e : set) {
            if (e instanceof NetInstance || placeInstance.getTokenCount(e) == placeInstance2.getTokenCount(e)) continue;
            return false;
        }
        return true;
    }

    private boolean containedNetInstanceTokensEqual(NetInstance netInstance, Set<Place> set, Map<ResettableNetInstance, ResettableNetInstance> map) {
        if (!set.isEmpty()) {
            HashSet<Place> hashSet = new HashSet<Place>(set);
            Place place = (Place)hashSet.iterator().next();
            hashSet.remove(place);
            PlaceInstance placeInstance = this.getInstance(place);
            PlaceInstance placeInstance2 = netInstance.getInstance(place);
            Set set2 = placeInstance.getDistinctTokens();
            Set set3 = placeInstance2.getDistinctTokens();
            return this.placesNetInstanceTokensEqual(netInstance, placeInstance, placeInstance2, set2, set3, map, hashSet);
        }
        return true;
    }

    private boolean placesNetInstanceTokensEqual(NetInstance netInstance, PlaceInstance placeInstance, PlaceInstance placeInstance2, Set<Object> set, Set<Object> set2, Map<ResettableNetInstance, ResettableNetInstance> map, Set<Place> set3) {
        HashSet<Object> hashSet = new HashSet<Object>(set);
        while (!hashSet.isEmpty()) {
            Object object = hashSet.iterator().next();
            hashSet.remove(object);
            if (object instanceof ResettableNetInstance) {
                int n = placeInstance.getTokenCount(object);
                ResettableNetInstance resettableNetInstance = (ResettableNetInstance)((Object)object);
                ResettableNetInstance resettableNetInstance2 = map.get(object);
                if (resettableNetInstance2 != null) {
                    if (n == placeInstance2.getTokenCount((Object)resettableNetInstance2)) continue;
                    return false;
                }
                for (Object object2 : set2) {
                    if (!(object2 instanceof NetInstance) || map.values().contains(object2) || n != placeInstance2.getTokenCount(object2) || !resettableNetInstance.stateEquals(object2, map)) continue;
                    if (this.placesNetInstanceTokensEqual(netInstance, placeInstance, placeInstance2, hashSet, set2, map, set3)) {
                        return true;
                    }
                    map.remove((Object)resettableNetInstance);
                }
                return false;
            }
            if (!(object instanceof NetInstance)) continue;
            throw new RuntimeException("A " + ResettableNetInstance.class.getSimpleName() + " object may not contain " + NetInstance.class.getSimpleName() + " tokens.");
        }
        return this.containedNetInstanceTokensEqual(netInstance, set3, map);
    }
}

