/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.xml;

import de.renew.gui.CPNDrawing;
import de.renew.gui.xml.IgnoreElementState;
import de.renew.gui.xml.NetParseState;
import de.renew.gui.xml.ParseState;
import de.renew.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XRNParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger(XRNParser.class);
    private CPNDrawing result = new CPNDrawing();
    private ParseState state = null;

    XRNParser() {
    }

    public static CPNDrawing parse(InputStream inputStream) throws SAXException, IOException {
        XMLReader xMLReader;
        InputSource inputSource = new InputSource(inputStream);
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException(factoryConfigurationError);
        }
        XRNParser xRNParser = new XRNParser();
        xMLReader.setContentHandler(xRNParser);
        xMLReader.setEntityResolver(xRNParser);
        xMLReader.parse(inputSource);
        return xRNParser.result;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        if (string2.startsWith("http://www.renew.de/") || string2.startsWith("http://www.informatik.uni-hamburg.de/TGI/renew/")) {
            String string3 = StringUtil.getExtendedFilename((String)string2);
            System.out.println("[XRNParser] dtd is " + string3);
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(XRNParser.class.getSimpleName() + ": DTD input stream: " + String.valueOf(this.getClass().getResource(string3)) + String.valueOf(inputStream)));
            }
            if (inputStream == null) {
                return null;
            }
            return new InputSource(inputStream);
        }
        return null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(XRNParser.class.getSimpleName() + ": startElement Name: " + string3 + " localName: " + string2 + " Atts: " + String.valueOf(attributes)));
        }
        this.state = this.state != null ? this.state.startElement(string3, attributes) : ("net".equals(string3) ? new NetParseState(this.result, attributes) : new IgnoreElementState(null));
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.state != null) {
            this.state = this.state.endElement(string3);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.state != null) {
            this.state = this.state.characters(cArray, n, n2);
        }
    }
}

