/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.ArcConnection;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.AttributeParser;
import de.renew.gui.pnml.parser.ObjectParser;
import java.awt.Point;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ArcParser
extends ObjectParser {
    private Map<String, Integer> _keys;
    private String _sourceString;
    private String _targetString;
    private Drawing _net;

    public ArcParser(Element element, Map<String, Integer> map, Drawing drawing, NetConverter netConverter) {
        super(element, netConverter);
        this._keys = map;
        this._net = drawing;
    }

    @Override
    protected FigureWithID createObject() {
        ArcConnection arcConnection = new ArcConnection(1);
        for (AttributeParser attributeParser : this.getAttributes()) {
            if (!attributeParser.attributeName().equals("ArcType")) continue;
            String string = attributeParser.attributeValue();
            if (string.equals("inhibitor")) {
                arcConnection = new InhibitorConnection();
                continue;
            }
            if (string.equals("multi-ordinary")) {
                arcConnection = new DoubleArcConnection();
                continue;
            }
            if (string.equals("clear")) {
                arcConnection = new HollowDoubleArcConnection();
                continue;
            }
            if (string.equals("both")) {
                arcConnection = new ArcConnection(2);
                continue;
            }
            if (!string.equals("test")) continue;
            arcConnection = new ArcConnection(0);
        }
        arcConnection.startPoint(0, 0);
        arcConnection.endPoint(0, 0);
        return arcConnection;
    }

    @Override
    protected void parseFigure() {
        String string = this.getElement().getAttribute("source");
        String string2 = this.getElement().getAttribute("target");
        NodeList nodeList = this.getElement().getElementsByTagName("toolspecific");
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (!"renew".equals(element.getAttribute("tool"))) continue;
                if (element.hasAttribute("source")) {
                    string = element.getAttribute("source");
                }
                if (!element.hasAttribute("target")) continue;
                string2 = element.getAttribute("target");
            }
        }
        this._sourceString = string;
        this._targetString = string2;
    }

    private Connector findConnector(Drawing drawing, int n) {
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            FigureWithID figureWithID;
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof FigureWithID) || (figureWithID = (FigureWithID)figure).getID() != n) continue;
            Point point = figureWithID.center();
            return figureWithID.connectorAt(point.x, point.y);
        }
        return null;
    }

    @Override
    protected void doInitFigure() {
        int n;
        int n2;
        ArcConnection arcConnection = (ArcConnection)this.figure();
        if (this._keys.containsKey(this._sourceString)) {
            n2 = this._keys.get(this._sourceString);
        } else {
            try {
                n2 = ArcParser.parseNumericId(this._sourceString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Could not find PNML arc source with ID \"" + this._sourceString + "\"");
            }
        }
        if (this._keys.containsKey(this._targetString)) {
            n = this._keys.get(this._targetString);
        } else {
            try {
                n = ArcParser.parseNumericId(this._targetString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Could not find PNML arc target with ID \"" + this._targetString + "\"");
            }
        }
        arcConnection.connectStart(this.findConnector(this._net, n2));
        arcConnection.connectEnd(this.findConnector(this._net, n));
        arcConnection.updateConnection();
        super.doInitFigure();
    }

    @Override
    protected void initGraphic() {
        Serializable serializable;
        ArcConnection arcConnection = (ArcConnection)this.figure();
        int n = 1;
        Iterator<Point> iterator = this.getGraphic().positions();
        while (iterator.hasNext()) {
            serializable = iterator.next();
            arcConnection.insertPointAt((Point)serializable, n++);
        }
        serializable = this.getGraphic().getLineColor();
        String string = this.getGraphic().getLineStyle();
        if (serializable != null) {
            this.figure().setAttribute("FrameColor", (Object)serializable);
        }
        if (string != null) {
            this.figure().setAttribute("LineStyle", (Object)string);
        }
    }
}

