/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.TransactionSource;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Transaction {
    private boolean autoCommit;
    private Vector<NetAction> createActions;
    private Vector<NetAction> deleteActions;
    private static Logger logger = Logger.getLogger(Transaction.class);
    private Vector<TokenAction> delayedAddActions;
    private Vector<TokenAction> addActions;
    private Vector<TokenAction> removeActions;

    public Transaction(boolean bl) {
        this.autoCommit = bl;
        this.createActions = new Vector();
        this.deleteActions = new Vector();
        this.delayedAddActions = new Vector();
        this.addActions = new Vector();
        this.removeActions = new Vector();
    }

    public synchronized void createNet(NetInstance netInstance) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(Transaction.class.getSimpleName() + ": creating net action."));
        }
        this.createActions.addElement(new NetAction(netInstance));
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void deleteNet(NetInstance netInstance) throws Exception {
        this.deleteActions.addElement(new NetAction(netInstance));
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void addToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object, double d, boolean bl) throws Exception {
        simulatablePlaceInstance.reserve(object);
        TokenAction tokenAction = new TokenAction(simulatablePlaceInstance, object, d);
        if (bl) {
            this.delayedAddActions.addElement(tokenAction);
        }
        this.addActions.addElement(tokenAction);
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void removeToken(SimulatablePlaceInstance simulatablePlaceInstance, Object object, double d) throws Exception {
        simulatablePlaceInstance.reserve(object);
        this.removeActions.addElement(new TokenAction(simulatablePlaceInstance, object, d));
        if (this.autoCommit) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputTokens() {
        int n = this.delayedAddActions.size();
        for (int i = 0; i < n; ++i) {
            TokenAction tokenAction = this.delayedAddActions.elementAt(i);
            SimulatablePlaceInstance simulatablePlaceInstance = tokenAction.getPlaceInstance();
            Object object = tokenAction.getToken();
            double d = tokenAction.getTime();
            simulatablePlaceInstance.lock.lock();
            try {
                simulatablePlaceInstance.internallyInsertToken(object, d, false);
                continue;
            }
            finally {
                simulatablePlaceInstance.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserveTokens(Vector<TokenAction> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TokenAction tokenAction = vector.elementAt(i);
            SimulatablePlaceInstance simulatablePlaceInstance = tokenAction.getPlaceInstance();
            Object object = tokenAction.getToken();
            simulatablePlaceInstance.lock.lock();
            try {
                simulatablePlaceInstance.unreserve(object);
                continue;
            }
            finally {
                simulatablePlaceInstance.lock.unlock();
            }
        }
    }

    private void unreserveOutputTokens() {
        this.unreserveTokens(this.addActions);
    }

    private void unreserveInputTokens() {
        this.unreserveTokens(this.removeActions);
    }

    private void clear() {
        this.createActions.removeAllElements();
        this.delayedAddActions.removeAllElements();
        this.addActions.removeAllElements();
        this.removeActions.removeAllElements();
        this.deleteActions.removeAllElements();
    }

    public synchronized void commit() throws Exception {
        Object[] objectArray = new NetAction[this.createActions.size()];
        this.createActions.copyInto(objectArray);
        Object[] objectArray2 = new TokenAction[this.addActions.size()];
        this.addActions.copyInto(objectArray2);
        Object[] objectArray3 = new TokenAction[this.removeActions.size()];
        this.removeActions.copyInto(objectArray3);
        Object[] objectArray4 = new NetAction[this.deleteActions.size()];
        this.deleteActions.copyInto(objectArray4);
        TransactionSource.perform((NetAction[])objectArray, (TokenAction[])objectArray2, (TokenAction[])objectArray3, (NetAction[])objectArray4);
        this.outputTokens();
        this.unreserveOutputTokens();
        this.unreserveInputTokens();
        this.clear();
    }

    public synchronized void rollback() {
        this.unreserveOutputTokens();
        this.unreserveInputTokens();
        this.clear();
    }
}

