/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;

class OverallEarliestTimeFinder
implements Finder {
    private Finder finder;
    private double overallEarliestTime = Double.POSITIVE_INFINITY;

    OverallEarliestTimeFinder(Finder finder) {
        this.finder = finder;
    }

    @Override
    public void found(Searcher searcher) {
        double d;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        double d2 = searcher.getEarliestTime();
        if (d2 < (d = SearchQueue.getTime())) {
            d2 = d;
        }
        if (d2 < this.overallEarliestTime) {
            this.overallEarliestTime = d2;
        }
        if (d2 == d) {
            this.finder.found(searcher);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.finder.isCompleted();
    }

    public double getOverallEarliestTime() {
        return this.overallEarliestTime;
    }

    public void insertIntoSearchQueue(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.overallEarliestTime < Double.POSITIVE_INFINITY) {
            SearchQueue.include(searchable, this.overallEarliestTime);
        }
    }
}

