/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.database.Transaction;
import de.renew.database.TransactionSource;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.TraceEvent;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.searcher.TriggerableCollectionImpl;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableMapper;
import de.renew.net.IDRegistry;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.TimeSet;
import de.renew.net.TokenSource;
import de.renew.net.event.PlaceEventListenerSet;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.DelayedFieldOwner;
import de.renew.util.Lock;
import de.renew.util.Orderer;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class SimulatablePlaceInstance
extends PlaceInstance
implements Serializable,
DelayedFieldOwner {
    static final long serialVersionUID = 0L;
    public static Logger logger = Logger.getLogger(SimulatablePlaceInstance.class);
    protected List<Object> initTokens;
    protected boolean earlyTokens;
    protected transient TriggerableCollection triggerables;
    public transient long lockOrder = Orderer.getTicket();

    SimulatablePlaceInstance(NetInstance netInstance, Place place, boolean bl) throws Impossible {
        super(netInstance, place);
        this.triggerables = new TriggerableCollectionImpl();
        this.initTokenStorage();
        this.earlyTokens = netInstance.getNet().earlyTokens;
        if (bl) {
            this.initTokens = new ArrayList<Object>();
            for (TokenSource tokenSource : place.inscriptions) {
                VariableMapper variableMapper = new VariableMapper();
                Variable variable = variableMapper.map(new LocalVariable("this", false));
                Unify.unify(variable, netInstance, null);
                Object object = tokenSource.createToken(variableMapper);
                this.initTokens.add(object);
                if (!this.earlyTokens) continue;
                this.internallyInsertToken(object, SearchQueue.getTime(), false);
            }
        } else {
            this.initTokens = Collections.emptyList();
        }
    }

    protected abstract void initTokenStorage();

    public String toString() {
        return this.netInstance.toString() + "." + this.place.toString();
    }

    public TriggerableCollection triggerables() {
        return this.triggerables;
    }

    public abstract Set<Object> getDistinctTokens(Object var1);

    public abstract Set<Object> getDistinctTestableTokens(Object var1);

    abstract boolean containsToken(Object var1);

    public abstract double computeEarliestTime(Object var1, TimeSet var2);

    public abstract boolean containsTestableToken(Object var1);

    protected IDRegistry registry() {
        return this.netInstance.getRegistry();
    }

    public void reserve(Object object) {
        this.registry().reserve(object);
    }

    public void reserve(Object object, int n) {
        this.registry().reserve(object, n);
    }

    public String getTokenID(Object object) {
        return this.registry().getID(object);
    }

    public void unreserve(Object object) {
        this.registry().unreserve(object);
    }

    public abstract double removeToken(Object var1, double var2) throws Impossible;

    public abstract double testToken(Object var1) throws Impossible;

    public abstract void extractAllTokens(Vector<Object> var1, Vector<Double> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTokenWithID(Object object, String string, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.lock.lock();
        try {
            this.registry().setAndReserveID(object, string);
            this.internallyInsertToken(object, d, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public abstract void internallyInsertToken(Object var1, double var2, boolean var4);

    public void transactionInsertToken(Object object, double d, boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Transaction transaction = TransactionSource.get();
        try {
            transaction.addToken(this, object, d, bl);
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void insertToken(Object object, double d) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.transactionInsertToken(object, d, true);
    }

    public abstract void untestToken(Object var1);

    private void traceInitialTokens(StepIdentifier stepIdentifier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        for (Object object : this.initTokens) {
            if (!this.place.getTrace()) continue;
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new TraceEvent("Initializing " + String.valueOf(object) + " into " + String.valueOf(this)), (PlaceInstance)this);
        }
    }

    @Override
    public void earlyConfirmation() {
        if (this.earlyTokens) {
            for (Object object : this.initTokens) {
                double d = SearchQueue.getTime();
                this.transactionInsertToken(object, d, false);
            }
        }
    }

    @Override
    public void earlyConfirmationTrace(StepIdentifier stepIdentifier) {
        if (this.earlyTokens) {
            this.traceInitialTokens(stepIdentifier);
        }
    }

    @Override
    public void lateConfirmation(StepIdentifier stepIdentifier) {
        if (!this.earlyTokens) {
            this.traceInitialTokens(stepIdentifier);
            for (Object object : this.initTokens) {
                this.insertToken(object, SearchQueue.getTime());
            }
        }
        this.initTokens = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RenewObjectOutputStream renewObjectOutputStream = null;
        if (objectOutputStream instanceof RenewObjectOutputStream) {
            renewObjectOutputStream = (RenewObjectOutputStream)objectOutputStream;
        }
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.beginDomain((Object)this);
        }
        objectOutputStream.defaultWriteObject();
        if (renewObjectOutputStream != null) {
            renewObjectOutputStream.delayedWriteObject((Object)this.triggerables, (DelayedFieldOwner)this);
            renewObjectOutputStream.endDomain((Object)this);
        } else {
            objectOutputStream.writeObject(this.triggerables);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lockOrder = Orderer.getTicket();
        this.lock = new Lock();
        this.listeners = new PlaceEventListenerSet();
        if (!(objectInputStream instanceof RenewObjectInputStream)) {
            this.triggerables = (TriggerableCollection)objectInputStream.readObject();
        }
    }

    public abstract void reassignField(Object var1) throws IOException;

    protected boolean tryReassignField(Object object) throws IOException {
        if (object instanceof TriggerableCollection) {
            this.triggerables = (TriggerableCollection)object;
            return true;
        }
        return false;
    }
}

