/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.PathEntry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringUtil {
    public static Logger logger = Logger.getLogger(StringUtil.class);
    public static final int separatorLength = File.separator.length();

    public static String replace(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n = n3)) >= 0) {
            stringBuffer.append(string.substring(n, n3));
            stringBuffer.append(string3);
            n3 += n2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String[] split(String object, String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = string.length();
        int n3 = 0;
        object = (String)object + string;
        while ((n3 = ((String)object).indexOf(string, n = n3)) >= 0) {
            if (n3 > n) {
                vector.addElement(((String)object).substring(n, n3));
            }
            n3 += n2;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String firstToUpperCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String firstToLowerCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static boolean isUpperCaseAt(String string, int n) {
        return n < string.length() && Character.isUpperCase(string.charAt(n));
    }

    public static boolean isLowerCaseAt(String string, int n) {
        return n < string.length() && Character.isLowerCase(string.charAt(n));
    }

    public static int countOccurences(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        while ((n2 = string.indexOf(string2, n2)) >= 0) {
            n2 += n3;
            ++n;
        }
        return n;
    }

    public static int countLines(String string) {
        return StringUtil.countOccurences(string, "\n") + 1;
    }

    public static String[] splitStringWithEscape(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            String string2;
            char c = cArray[i];
            if (c == '\\' && i + 1 < cArray.length && cArray[i + 1] == ' ') {
                bl2 = true;
            } else if (c == '\"' || c == '\'') {
                bl = !bl;
            } else if (c == '\n' || c == '\r' || c == '\t' || c == ' ') {
                if (bl) {
                    stringBuffer.append(c);
                } else if (bl2) {
                    stringBuffer.append(c);
                    bl2 = false;
                } else {
                    string2 = stringBuffer.toString();
                    stringBuffer = new StringBuffer();
                    if (!string2.matches("^\\s*$")) {
                        arrayList.add(string2);
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            if (i != cArray.length - 1) continue;
            string2 = stringBuffer.toString();
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static String join(Collection<String> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) break;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                stringBuilder.append(StringUtil.trimToEmpty(stringArray[i]));
            } else {
                stringBuilder.append(stringArray[i]);
            }
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static int getLastSeparatorPos(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(File.separator);
        }
        return n;
    }

    private static int getLastDotPos(String string) {
        int n = StringUtil.getLastSeparatorPos(string);
        int n2 = string.lastIndexOf(".");
        if (n2 > n) {
            return n2;
        }
        return string.length();
    }

    public static String stripFilenameExtension(String string) {
        return string.substring(0, StringUtil.getLastDotPos(string));
    }

    public static String extendFileNameBy(String string, String string2) {
        Object object = StringUtil.stripFilenameExtension(string);
        if (!string2.isEmpty()) {
            object = (String)object + "." + string2;
        }
        return object;
    }

    public static String getExtendedFilename(String string) {
        return string.substring(StringUtil.getLastSeparatorPos(string) + 1);
    }

    public static String getFilename(String string) {
        return string.substring(StringUtil.getLastSeparatorPos(string) + 1, StringUtil.getLastDotPos(string));
    }

    public static String getExtension(String string) {
        int n = StringUtil.getLastDotPos(string) + 1;
        if (n < string.length()) {
            return string.substring(n).toLowerCase();
        }
        return "";
    }

    public static String getPath(String string) {
        int n = StringUtil.getLastSeparatorPos(string);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String makeRelative(String object, String object2) {
        if (object2 != null) {
            if (object == null) {
                object2 = StringUtil.convertToSlashes((String)object2);
            } else {
                int n;
                object = (String)object + File.separator;
                int n2 = 0;
                do {
                    n = n2;
                } while ((n2 = ((String)object).indexOf(File.separator, n2) + separatorLength) != -1 + separatorLength && ((String)object2).startsWith(((String)object).substring(0, n2)));
                Object object3 = "";
                if (n > 0) {
                    n2 = n;
                    while ((n2 = ((String)object).indexOf(File.separator, n2)) >= 0) {
                        n2 += separatorLength;
                        object3 = (String)object3 + "../";
                    }
                }
                object2 = (String)object3 + StringUtil.convertToSlashes(((String)object2).substring(n));
            }
        }
        return object2;
    }

    public static String makeCanonical(String string) {
        String string2 = null;
        try {
            string2 = new File(string).getCanonicalPath();
            if (string2.equals(string2.toUpperCase())) {
                return StringUtil.getPath(string2) + File.separator + StringUtil.getExtendedFilename(string);
            }
            return string2;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static String makeAbsolute(String string, String string2) {
        if (string == null || "".equals(string) || string2.startsWith("/") || string2.length() > 2 && string2.charAt(1) == ':') {
            return StringUtil.convertToSystem(string2);
        }
        while (string2.startsWith("../")) {
            string2 = string2.substring(3);
            string = StringUtil.getPath(string);
        }
        return string + File.separator + StringUtil.convertToSystem(string2);
    }

    public static String convertToSlashes(String string) {
        return StringUtil.replace(string, File.separator, "/");
    }

    public static String convertToSystem(String string) {
        return StringUtil.replace(string, "/", File.separator);
    }

    public static String[] splitPaths(String string) {
        return StringUtil.split(string, File.pathSeparator);
    }

    public static String classToFile(String string) {
        return StringUtil.replace(string, ".", File.separator) + ".class";
    }

    public static String unspace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                bl = true;
                continue;
            }
            if (bl && !bl2) {
                stringBuffer.append(' ');
            }
            bl = false;
            bl2 = false;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean isNameOrEmpty(String string, boolean bl) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierStart(string.charAt(n++))) {
                return false;
            }
            while (n < string.length() && Character.isJavaIdentifierPart(string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) continue;
            if (!bl) {
                return false;
            }
            if (string.charAt(n++) != '.') {
                return false;
            }
            if (n != string.length()) continue;
            return false;
        }
        return true;
    }

    public static URI makeRelative(URI uRI, URI uRI2) {
        URI uRI3 = uRI.relativize(uRI2);
        if (uRI3.isAbsolute() && StringUtil.equalOrBothNull(uRI.getScheme(), uRI2.getScheme()) && StringUtil.equalOrBothNull(uRI.getAuthority(), uRI2.getAuthority())) {
            URI uRI4 = null;
            int n = 0;
            URI uRI5 = StringUtil.getParent(uRI, false);
            uRI3 = uRI5.relativize(uRI2);
            while (uRI3.isAbsolute() && !uRI5.equals(uRI4)) {
                uRI4 = uRI5;
                ++n;
                uRI5 = StringUtil.getParent(uRI4, true);
                uRI3 = uRI5.relativize(uRI2);
            }
            if (!uRI3.isAbsolute()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("../");
                }
                stringBuffer.append(uRI3.getPath());
                try {
                    uRI3 = new URI(uRI3.getScheme(), uRI3.getAuthority(), stringBuffer.toString(), uRI3.getQuery(), uRI3.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.error((Object)uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                    uRI3 = uRI2;
                }
            }
        }
        assert (uRI.resolve(uRI3).equals(uRI2)) : "StringUtil.makeRelative result does not hold its contract.\n  given uri=" + String.valueOf(uRI2) + "\n  verified =" + String.valueOf(uRI.resolve(uRI3)) + "\n  result   =" + String.valueOf(uRI3) + "\n  baseURI  =" + String.valueOf(uRI);
        return uRI3;
    }

    private static boolean equalOrBothNull(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public static URI getParent(URI uRI, boolean bl) {
        String string = uRI.getPath();
        String string2 = null;
        if (string != null) {
            int n;
            if (bl && string.endsWith("/") && string.length() > 1) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n = string.lastIndexOf("/")) >= 0) {
                string2 = string.substring(0, n + 1);
            }
        }
        try {
            URI uRI2 = new URI(uRI.getScheme(), uRI.getAuthority(), string2, null, null);
            return uRI2;
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error((Object)uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            throw new IllegalArgumentException("StringUtil: Could not derive parent URI from " + String.valueOf(uRI));
        }
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isEmpty(String string) {
        return string != null && string.trim().length() == 0;
    }

    public static boolean isNullOrEmpty(String string) {
        return StringUtil.isNull(string) || StringUtil.isEmpty(string);
    }

    public static String trimToNull(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return string.trim();
    }

    public static String trimToEmpty(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.trim();
    }

    public static String getPart(String string, int n, String string2) {
        if (StringUtil.trimToNull(string) == null || n < 0) {
            return null;
        }
        String[] stringArray = string.split(string2);
        if (stringArray == null || stringArray.length <= n) {
            return null;
        }
        return stringArray[n];
    }

    public static String camelCase(String string, String string2, boolean bl) {
        String[] stringArray = string.split(string2);
        StringBuilder stringBuilder = new StringBuilder(bl ? StringUtil.firstToUpperCase(stringArray[0]) : StringUtil.firstToLowerCase(stringArray[0]));
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(StringUtil.firstToUpperCase(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String camelCase(String string, boolean bl) {
        return StringUtil.camelCase(string, "-", bl);
    }

    public static String camelCase(String string) {
        return StringUtil.camelCase(string, true);
    }

    public static String spinalCase(String string) {
        Pattern pattern = Pattern.compile("[A-Z]");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            if (n2 <= 0) continue;
            String string2 = string.substring(n, n2);
            stringBuilder.append(string2.toLowerCase());
            stringBuilder.append("-");
            n = n2;
        }
        stringBuilder.append(string.substring(n).toLowerCase());
        return stringBuilder.toString();
    }

    public static String upperCaseWords(String string) {
        String[] stringArray = string.split(" ");
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringUtil.firstToUpperCase(stringArray[i].toLowerCase());
        }
        return StringUtil.join(stringArray2, " ");
    }

    public static PathEntry[] canonizePaths(String[] stringArray) {
        if (stringArray == null) {
            return new PathEntry[0];
        }
        PathEntry[] pathEntryArray = new PathEntry[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            pathEntryArray[i] = stringArray[i].trim().startsWith("CLASSPATH" + File.separator) ? new PathEntry(stringArray[i].trim().substring(9 + File.separator.length()), true) : (stringArray[i].trim().equals("CLASSPATH") ? new PathEntry("", true) : new PathEntry(StringUtil.makeCanonical(stringArray[i]), false));
        }
        return pathEntryArray;
    }
}

