/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.lola.LolaResult;
import de.renew.lola.LolaTask;
import de.renew.lola.commands.CheckVerificationRequestCommand;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class CheckAllTasksCommand
extends Command
implements CLCommand {
    private static Logger logger = Logger.getLogger(CheckVerificationRequestCommand.class);

    public CheckAllTasksCommand(String string) {
        super(string);
    }

    public void execute() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        Drawing drawing = drawApplication.drawing();
        drawApplication.getUndoRedoManager().prepareUndoSnapshot(drawing);
        if (!(drawing instanceof CPNDrawing)) {
            logger.error((Object)"[Lola] Drawing needs to be a CPNDrawing. Aborting.");
            return;
        }
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            LolaTask lolaTask;
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (!(figure instanceof TextFigure) || !(lolaTask = new LolaTask((TextFigure)figure, (CPNDrawing)drawing)).isValid()) continue;
            File file = lolaTask.writeToFile();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[Lola Task] created file " + file));
            }
            LolaResult lolaResult = lolaTask.check();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[Lola Task] checked, result is " + lolaResult.getExitValue()));
            }
            lolaTask.colorFigure();
        }
        drawApplication.getUndoRedoManager().commitUndoSnapshot(drawing);
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return null;
    }
}

